//
// ysrv_session.cc for libyourserver in src/libyourserver
// 
// Made by Dias Da Silva Loic <mglcel@linuxfr.net>
// 
// Started on      Fri Nov  3 15:46:19 2000 by Dias Da Silva Loic
// Last updated on Sun Nov 26 14:56:04 2000 by 
// 
// Description : The Session class


//
#include <stdio.h>
#include <unistd.h>

#include "libyourserver.h"

// Make an intermediate session
// Wait for a incoming connection, verify access
// Attach the session to the server and create a new
// intermediate session
Session::Session (Server* _server, int _sock, 
		  s_config* _config, unsigned int* _nb_sessions,
		  SESSION_FUNC((*_ETA_client_func)), 
		  SESSION_FUNC((*_ETA_server_func)), char* _retry_msg) :
  Connexion (_sock, _config)
{
  FUNC_DEBUG ("Session instance creation");

  char message[512];

  this->alive     = TRUE;
  this->my_server = _server;

  this->my_server->attach_session (this, _ETA_client_func,
				   _ETA_server_func, _retry_msg);
  
  if ( this->status == C_ETA_CLIENT || this->status == C_ETA_SERVER )
    {
      if (*_nb_sessions > MAX_CONNECTIONS-1)
	{
	  sprintf (message, "Incoming connexion from %s", 
		   this->get_peer_addr ());
	  ysrv_log_info(message);
	  
	  pth_write(this->sock, _retry_msg, strlen(_retry_msg));
	}
      else
	{	  
	  sprintf (message, "Incoming connexion from %s", 
		   this->get_peer_addr ());
	  ysrv_log_info(message);
	  
	  if (this->status == C_ETA_CLIENT)
	    if (_ETA_client_func)
	      (*_ETA_client_func)(this->sock, this->get_peer_addr ());
	  else
	    if (_ETA_server_func)
	      (*_ETA_server_func)(this->sock, this->get_peer_addr ());
	}
    }
  this->my_server->detach_session (this);
}

// -----

Session::~Session ()
{
  FUNC_DEBUG ("Session instance destroying...");

  this->alive = FALSE;
}
