//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// yoursqld.cc for yoursql in src/yoursqld
// 
// Made by  <mglcel@linuxfr.net>
// 
// Started on      Fri Nov 24 19:15:01 2000 by 
// Last updated on Sun Nov 26 14:10:17 2000 by 
// 
// Description : Main funtion
//

#include <signal.h>
#include <unistd.h>

#include "yoursqld.h"

Application* YourSQLd = NULL;

void ysrv_term_handler (int signum )
{
  YSRV_KILL(YourSQLd);
  cout << "Bye" << endl;
  ysrv_log_info ("Exiting...");
  exit (0);
}

// -----

SESSION_FUNC(open_client_session)
{ 
  pth_write (_peersock, "\n\nYou're connected...\n\n\n", 25);
  pth_write (_peersock, _peeraddr, strlen (_peeraddr));
  pth_write (_peersock, "\n\n\n", 3);

  pth_sleep (5);
}

// -----

int
main (int argc, char** argv)
{
  if ((int) getuid () == 0)
    {
      if (chroot ("/tmp/") == -1)
	ERR (INVALID_CHROOT);
      
      if (setuid ((uid_t) 1000) == -1)
	ERR (INVALID_SETUID);
      
      setgid ((gid_t) 1000);
    }
  
  signal (SIGTERM, ysrv_term_handler);
  signal (SIGINT, ysrv_term_handler);
  signal (SIGHUP, ysrv_term_handler);
  
  YSRV_INIT;

  if ((YourSQLd = new Application ()))
    (void) YourSQLd->create_new_server (&open_client_session, NULL, 
					"Retry later...\n");
  
  YSRV_MAIN_LOOP;

  ysrv_term_handler (0);
  
  return 1;
}
