# Class: wordpress
#
# This class Install and pre configure wordpress
#
# Parameters:
#
# Actions:
#   - Install and pre configure
#
# Requires:
# - DavidSchmitt-mysql-1.1.0
# Sample Usage:
#   
#
define wordpress::configure($sitedir="/var/www/", $blogname='wordpress', $template='wordpress/wp-config.php.erb', $dbname='wordpress', $dbuser='wordpress', $userpass='wordpress123') {

	include wordpress

        file { "${sitedir}${blogname}/wp-config.php":

			content => template($template),
			owner => "root",
	    		group => "root",
			ensure => "present"
	}


	mysql_user{ "${dbuser}":
		password_hash => mysql_password("${userpass}"),
		ensure => present
	}

	mysql_grant { "${dbuser}":
		privileges => [ "select_priv", 'insert_priv', 'delete_priv' ],
	}

	mysql_database { "${dbname}": ensure => present }



}
