# Class: wordpress
#
# This class Install wordpress
#
# Parameters:
#
# Actions:
#   - Install
#
# Requires:
# - DavidSchmitt-mysql-1.1.0
# Sample Usage:
#   
#
define wordpress::install($blogname='wordpress', $blogdir='/var/www/') {

	include wordpress	

	$downdir = "/tmp/"
	
	# Install wordpress package
	# - Will be installed automatically: apache,php,mysql
	#
	package { "wordpress": ensure => present }

	# Create configuration file for virtual host
	case $operatingsystem {
		CentOS: { file {"/etc/httpd/conf.d/${blogname}.conf": content => template('wordpress/wp-vhost.conf.erb'), owner => "root", group => "root" }}
		Debian: { file {"/etc/apache2/conf.d/${blogname}.conf": content => template('wordpress/wp-vhost.conf.erb'), owner => "root", group => "root" }}
	}

	# Create Blog directory	
	file { "${blogdir}${blogname}": ensure => "directory", owner => "root", group => "root",}

	# Copy Wordpress template directory
	exec {"cp -r /usr/share/wordpress/* ${blogdir}${blogname}":
		path => ["/usr/local/bin","/opt/local/bin","/usr/bin","/usr/sbin"]	
	}
		
}
