#!/usr/bin/python
from threading import Thread, Event
from SimpleXMLRPCServer import SimpleXMLRPCServer
import xmlrpclib
from libglade import *
import gtk

#------------
# InternetListener
# this is a thread that has an XMLRPC server in it
#------------
class InternetListener(Thread):
	def __init__(self, obj):
		Thread.__init__(self, group=None, name="IListner")

		self.end = Event()
		global listenPort

		self.foob = SimpleXMLRPCServer(( '',int(listenPort) ))
		self.foob.register_instance( obj )
		self.foob.register_function( self.Burp )

		self.start()

	def run(self):
		while( 1 ):
			if self.end.isSet():
				break
			print "Gonna handle a request now..."
			self.foob.handle_request()

	def ForceDelete(self):
		self.end.set()
		# need to burp out the handle_request()
		global listenPort
		server = xmlrpclib.Server( "http://localhost" \
		                         + ":" + listenPort \
					 + "/" )
		server.Burp()

	def Burp(self):
		return 1


#------------
# StartupWindow
#------------
class StartupWindow:
	def __init__(self):

		self.widgetTree = GladeXML("startup.glade")

		dic = { "on_window1_destroy" : self.accept_changes,
		        "on_accept_changes" : self.accept_changes
		      }

		self.widgetTree.signal_autoconnect (dic)
		gtk.mainloop()
	
	def accept_changes(self, obj):
		global listenPort
		global sendPort
		listenPortWidget = self.widgetTree.get_widget("listenport")
		sendPortWidget = self.widgetTree.get_widget("sendport")
		listenPort = listenPortWidget.get_text()
		sendPort = sendPortWidget.get_text()
		gtk.mainquit()



#------------
# TestWindow 
#  I can be called in the local thread, but don't use me in
#  XMLRPCServer, or i'll lock
#------------
class TestWindow:
	def __init__(self):

		self.widgetTree = GladeXML("project1.glade")

		dic = { "on_window1_destroy" : self.stop,
		        "on_button1_clicked" : self.sendMsg
		      }

		self.widgetTree.signal_autoconnect (dic)

		self.server = xmlrpclib.Server( "http://localhost" \
		                         + ":" + sendPort \
					 + "/" )
	
	def start(self):
		gtk.mainloop()

	def stop(self, obj):
		gtk.mainquit()
		return 1

	def sendMsg(self, obj):
		entryWidget = self.widgetTree.get_widget("entry1")
		message = entryWidget.get_text()

		global sendPort 
		print "Sending this: " + message + " on port " + sendPort
		return self.server.write( message )

	def write(self, word):
		print "I'm going to write something: " + word
		label = self.widgetTree.get_widget("label1")
		label.set_text( word )
		return 1


#------------
# SafeTestWindow 
#  i wrap my functions in threads_enter and threads_leave, so I can
#  be safely put into an XMLRPCServer
#------------
class SafeTestWindow(TestWindow):
	def _dispatch(self, methodStr, params):
		method = getattr(self, methodStr)
		gtk.threads_enter()
		retval = apply(method, params)
		gtk.threads_leave()
		return retval


listenPort = 8100
sendPort = 8101
questionWindow = StartupWindow()

window = SafeTestWindow()
#this starts up a new thread that listens for requests
ears = InternetListener( window )
#this starts up the gui
window.start()

ears.ForceDelete()
