#!/usr/bin/env python

# Adapted to demonstrate my bug? -dave aitel 2004
# Adapted from a post by Alif Wahid on the pyGTK mailinglist.
# Cedric Gustin, August 2003

import os
import sys
sys.path.append("/usr/local/lib/python2.2/site-packages/")
import time

#This program requires GTK 1.2
#make sure the python in your current path can use GTK 1.2 - check to make sure
#/usr/bin/python and /usr/local/bin/python are the same if you have problems
#on one account and not on others.

def try_import():
    import sys
    """tries to import gtk and if successful, returns 1"""
    print "Attempting to load gtk...Path=%s"%sys.path
    # To require 1.2
    try:
        import pygtk
        pygtk.require("2.0")
    except:
        print "pyGTK not found. You need GTK 2 to run this."
        print "Did you \"export PYTHONPATH=/usr/local/lib/python2.2/site-packages/\" first?"
        print "Perhaps you have GTK2 but not pyGTK, so I will continue to try loading."
        
        
    try:
        import gtk,gtk.glade
        import atk,pango #for py2exe
        import gobject
    except:
        import traceback,sys
        traceback.print_exc(file=sys.stdout)
        print "I'm sorry, you apparantly do not have GTK2 installed - I tried"
        print "to import gtk, gtk.glade, and gobject, and I failed."
        return 0
    return 1

if not try_import():
    site_packages=0
    #for k in sys.path:
    #    if k.count("site-packages"):
    #        print "existing site-packages path %s found\n"%k
    #        site_packages=1
    if site_packages == 0:
        from stat import *
        print "no site-packages path set, checking.\n"
        check_lib = [ "/usr/lib/python2.2/site-packages/",
                        "/usr/local/lib/python2.2/site-packages/",
                        "/usr/local/lib/python2.3/site-packages/" ]
        for k in check_lib:
            try:
                path=os.path.join(k,"pygtk.py")
                print "Path=%s"%path
                if open(path)!=None:
                    print "appending", k
                    sys.path=[k]+sys.path
                    if try_import():
                        break
            except:
                pass
    if not try_import():
        sys.exit(0)
        
import gtk,gtk.glade
import atk,pango #for py2exe
import gobject
#sys.path.append('gui')


def blah(a,b,c):
    return

bobsarray=[]

def do_listener_shell():
    """
    Creates a Listener-Shell window, attaches the events
    """
    global bobsarray

    listenerid=1
    #first connect the signal handlers
    wTreeTmp=gtk.glade.XML("canvasgui2.glade","listenershell")
    bobsarray+=[wTreeTmp]
    print "wTreeTmp=%s"%wTreeTmp
    wid=wTreeTmp.get_widget("listenershell")
    print "wid=%s"%wid
    dic= {"on_piped_clicked": (blah,wTreeTmp,listenerid),
            "on_pwd_clicked": (blah, wTreeTmp,listenerid),
            "on_cd_clicked": (blah, wTreeTmp,listenerid),
            "on_download_clicked":(blah, wTreeTmp,listenerid),
            "on_upload_clicked":(blah, wTreeTmp,listenerid),
            "on_dir_clicked":(blah, wTreeTmp,listenerid),
            "on_unlink_clicked":(blah, wTreeTmp,listenerid),
            "on_spawn_clicked":(blah, wTreeTmp,listenerid),
            #"on_cancel_clicked": wid.destroy,
            #"gtk_widget_destroy": wid.destroy
          }
    dic = {}
    print "Before signal connect"
    wTreeTmp.signal_autoconnect (dic)
    print "After signal connect"
    tb=gtk.TextBuffer(None)
    print "Got text buffer"
    wid=wTreeTmp.get_widget("text10")
    print "text10"
    wid.set_buffer(tb)
    print "wid set buffer"
    #ok, set buffer now
    return



from threading import Thread

threadcount=0
import random
import socket
import time
class gui_queue:
    """wakes up the gui thread which then clears our queue"""
    def __init__(self,listenport=0):
        """If listenport is 0, we create a random port to listen on"""
        self.myqueue=[]
        if listenport==0:
            self.listenport=random.randint(1025,10000)
        else:
            self.listenport=listenport
        print "Listening on port %s"%self.listenport
        s=socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        s.bind(("", self.listenport))  
        self.listensocket=s
        self.listensocket.listen(300) #listen for activity.
        #time.sleep(15)
        return
    
    def append(self,command,args):
        self.myqueue.append((command,args))
        s=socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        #wakey wakey!
        print "Connecting to port %d"%self.listenport
        s=s.connect(("localhost",self.listenport))
        return

    def clearqueue(self):
        print "Clearing queue"
        #clear this...TODO: add select call here.
        newconn,addr=self.listensocket.accept()
        for i in self.myqueue:
            (command,args)=i
            if command=="set_label":
                print "setting label"
                obj=args[0]
                label=args[1]
                obj.set_label(label)
            elif command=="do_listener_shell":
                do_listener_shell()
            else:
                print "Did not recognize action to take %s:"%(command,args)
        self.myqueue=[]
        return 1
    
myqueue=gui_queue()    

def clearqueue(source,condition):
    """
    Ignores source and condition
    """
    myqueue.clearqueue()
    return 1 #must return one to continue listening.
    

class Test (Thread):
    def __init__ (self,button, count=0):
        Thread.__init__(self)
        self.count = count
        self.button=button

    def run (self):
        gtk.threads_enter()
        #this should work but doesn't
        #do_listener_shell()
        gtk.threads_leave()
        for i in range(0,10):
            time.sleep(1)
            # Acquire and release the lock each time.
            #gtk.threads_enter()
            myqueue.append("set_label",[button,"Thread %002d - %d" % (self.count,i)])
            myqueue.append("do_listener_shell",None)
            #self.button.set_label("Thread %002d - %d" % (self.count,i))
            #gtk.threads_leave()
        gtk.threads_enter()
        self.button.set_label("  Start Thread  ")
        gtk.threads_leave()

def start_new_thread (button, data=None):
    global threadcount
    threadcount += 1

    a = Test(button,threadcount)
    a.start()


def hello(*args):
    """ Callback function that is attached to the button """
    print "hello"
    window.destroy()

def destroy(*args):
    """ Callback function that is activated when the program is destoyed
"""
    window.hide()
    gtk.main_quit()

    
if __name__ == '__main__':

    
    
    # Initialize threads
    gtk.threads_init()
    #wTreeTmp=gtk.glade.XML("canvasgui2.glade","listenershell")
    window = gtk.Window(gtk.WINDOW_TOPLEVEL)
    window.connect("destroy", destroy)
    window.set_border_width(10)

    gtk.input_add(myqueue.listensocket,gtk.gdk.INPUT_READ,clearqueue)
    button = gtk.Button("  Start Thread  ")
    button.connect("clicked", start_new_thread,button)
    window.add(button)
    button.show()
    
    window.show_all()
    gtk.threads_enter()
    gtk.main()
    gtk.threads_leave()

        