#!/usr/bin/env python
ISDEBUG  = True
# ENGINE PARAMS BEGIN
MPLAYER = "mplayer " # The execute string for mplayer command
# ENGINE PARAM END

import os, gobject
import threading # for the locks
import fcntl, time
#try:
#	import pygtk
#	pygtk.require("2.0")
#except:
#	pass
#try:
#	import gtk
#	import gtk.glade
#except:
#	print "Fail engine"
#	sys.exit(1)
MP_ERR_NONE                  = 0
MP_ERR_CMD_EXEC              = 1
MP_ERR_PLAY                  = 2
MP_ERR_CLOSE_PIPECLOSE       = 4
MP_ERR_CLOSE_CALLBACKREMOVE  = 8
MP_ERR_CLOSE                 = 16
MP_ERR_HUP                   = 32

class Mplayer:
	pipeM = None
	err = MP_ERR_NONE
	tags = []
	ans = []
	alltagsdone = False
	statusCMD = False
	def __init__(self):
		self.lkCMD = threading.Lock()
		self.lkMCalls = threading.Lock() # to have only operation among play stop pipeHUP
		self.lkAns = threading.Lock() # to handle read /delete oper maintaining thread safety
	#
	
	# STATE FNS START
	def query_can_exec_cmd(self):
		if self.statusCMD == False :
			return False
		if self.err & MP_ERR_HUP == MP_ERR_HUP:
			return False
		return True
	#
	
	def query_is_playing(self):
		# TODO
		if not self.pipeM:
			return False
		if self.err & MP_ERR_HUP == MP_ERR_HUP:
			return False
		return True
	#
	
	# STATE FNS END
	
	def play_start(self,filepath,playOpts):
		self.lkMCalls.acquire()
		if self.query_is_playing():
			self.stop_start()
		cmd = MPLAYER + playOpts + ' -slave "' + filepath + '" '
		try:
			self.alltagsdone = False
			self.tags = []
			self.ans = []
			self.pipeM = os.popen4(cmd)
			fcntl.fcntl(self.pipeM[1], fcntl.F_SETFL, os.O_NONBLOCK)
			self.sigIN = gobject.io_add_watch(self.pipeM[1],gobject.IO_IN,self.pipeIN)
			self.sigHUP = gobject.io_add_watch(self.pipeM[1],gobject.IO_HUP,self.pipeHUP)
			self.statusCMD = True
			self.err = self.err & ( ~ MP_ERR_PLAY ) 
		except:
			self.err = self.err | MP_ERR_PLAY
		self.lkMCalls.release()
	#
	
	def stop_start(self):
		self.lkMCalls.acquire()
		if not self.pipeM:
			return
		try:
			self.mplayer_cmd("quit")
			self.statusCMD = False
			self.err = self.err & ( ~ MP_ERR_CLOSE )
		except:
			self.err = self.err | MP_ERR_CLOSE

		try:
			if self.pipeM:
				self.pipeM[0].close()			
				self.pipeM[1].close()			
				self.pipeM = None
			self.err = self.err & ( ~ MP_ERR_CLOSE_PIPECLOSE )
		except:
			self.err = self.err | MP_ERR_CLOSE_PIPECLOSE
		try:
			if self.sigHUP > -1 :
				gobject.source_remove(self.sigHUP)
			if self.sigIN > -1 :
				gobject.source_remove(self.sigIN)
			self.err = self.err & ( ~ MP_ERR_CLOSE_CALLBACKREMOVE )
		except:
			self.err = self.err | MP_ERR_CLOSE_CALLBACKREMOVE
		self.tags = []
		self.lkMCalls.release()
	#	       
	def pause_toggle(self):
		self.mplayer_cmd("pause")
	#
	
	def volume_set(self,percent):
		self.mplayer_cmd("volume " + percent)
	#
	def position_get_start(self):
		self.mplayer_cmd("get_percent_pos")
	#
	def position_set(self,percent):
		self.mplayer("seek " + percent + " 1")
	#
	
	def ans_get_all_hold(self):
		self.lkAns.acquire()
		return self.ans
	#
	
	def ans_get_all_unhold(self):
		self.lkAns.release()
	#
	def ans_del_all(self):
		self.lkAns.acquire()
		self.ans = []
		self.lkAns.release()
	#
	def ans_del_all_hold(self):
		self.lkAns.acquire()
		self.ans = []
	#
	def ans_del_all_unhold(self):
		self.lkAns.release()
	#

	def ans_del(self,i):
		self.lkAns.acquire()
		try:
			self.ans.pop(i)
		except:
			if ISDEBUG:
				print "invalid ans pop index"
			pass
		self.lkAns.release()
	#
	
	def mplayer_cmd(self,cmd): # Exec 1 cmd at one time
		self.lkCMD.acquire()
		if self.query_can_exec_cmd():
			try:
				self.pipeM[0].write(cmd + "\n")
				self.err = self.err & ( ~ MP_ERR_CMD_EXEC )
			except:
				self.err = self.err | MP_ERR_CMD_EXEC
		self.lkCMD.release()
	#
	
	def mplayer_cmd_hold(self,cmd): # Exec 1 cmd at one time and wait for user 2 continue
		self.lkCMD.acquire()
		if self.query_can_exec_cmd():
			try:
				self.pipeM[0].write(cmd + "\n")
				self.err = self.err & ( ~ MP_ERR_CMD_EXEC )
			except:
				self.err = self.err | MP_ERR_CMD_EXEC
	#
	def mplayer_cmd_unhold(self):
		self.lkCMD.release()
	
	# PIPE CALLBACKS
	def pipeHUP(self,source,condition):
		self.lkMCalls.acquire()
		print "HUP occured"
		self.err = self.err | MP_ERR_HUP
		gobject.source_remove(self.sigHUP)
		self.sigHUP = -1 
		self.lkMCalls.release()
		return False
	#
	
	
	def pipeIN(self,source,condition):
		if ISDEBUG:
			print "in " 
		try:
			for datax in self.pipeM[1]:
				dataxx = datax.strip()
				if ISDEBUG:
					print dataxx
				if dataxx.startswith("ID_"):
					self.tags.append(dataxx)
				if dataxx.startswih("ANS_")
					self.ans.append(dataxx)
				if dataxx.startswith("Starting"):
					self.alltagsdone = True
					if ISDEBUG:
						print "All Tags done"
				
		except:
			time.sleep(0.05)
			pass
		return True
	#
	
	def querySlave(self):
		print "slave"
		self.mplayer_cmd("get_percent_pos")
		time.sleep(0.05)
		for datax in self.pipeM[1]:
			print datax.strip()
		return True
