#encoding: utf-8

'''
Created on Feb 16, 2012

@author: joseph
'''
from view.main_window import MainWindow

from threading import Thread
import gtk
from controller.camera import Camera

# it's just a class that will control the window called MainWindow.
# there, exists a menuitem called 'Iniciar Captura' that call
# MainController.iniciarCaptura event, that you can see at line 49
class MainController(object):
    '''
    classdocs
    '''

    def __init__(self):
        '''
        Constructor
        '''
        print ("Starting...")
        
        self.initMainWindow()
        
        gtk.main()
    
    def initMainWindow(self):
        self.mainWindow = MainWindow()
        self.mainWindow.connect('destroy', self.sair)
        self.mainWindow.connect('delete_event', self.ignore)
        
        self.mainWindow.iniciarCapturaMenuItem.connect('activate', self.iniciarCaptura)
        self.mainWindow.pararCapturaMenuItem.connect('activate', self.pararCaptura)
        self.mainWindow.sairMenuItem.connect('activate', self.sairDialog)
        self.mainWindow.sobreMenuItem.connect('activate', self.sobreDialog)
    
    def ignore(self, widget, event):
        self.sairDialog(widget)
        return True
    
    # here is called when 'Iniciar Captura' is clicked.
    # it means that capture from camera must be started.
    # Them, it call Camera from controller.camera
    def iniciarCaptura(self, widget):
        print('Iniciar Captura')
        
        self.camera = Camera(self.mainWindow)
            
        self.th = Thread(target=self.camera.runvideo)
        self.th.start()
    
    def n(self):
        self.initMainWindow()
    
    
    
    def pararCaptura(self, widget):
        self.running = False
        print('Parar Captura')
    
    def sairDialog(self, widget):
        question = gtk.Label('Deseja realmente sairDialog?')
        question.show()
        
        dialog = gtk.Dialog(
            'Sair',
            self.mainWindow,
            gtk.DIALOG_MODAL,
            (
                '_Sim', gtk.RESPONSE_YES,
                '_Não', gtk.RESPONSE_NO
            )
        )
        
        dialog.vbox.pack_start(question)
        dialog.set_border_width(10)
        
        ans = dialog.run()
        dialog.destroy()
        if ans  == gtk.RESPONSE_YES:
            self.mainWindow.destroy()
            self.sair(widget)
                
    def sobreDialog(self, widget):
        print('Ajuda')
        text = gtk.Label('Olá, tudo bem?\nEu sou Joseph Soares Alcântara')
        text.show()
        
        dialog = gtk.Dialog(
            'Sobre',
            self.mainWindow,
            0,
            ('Fechar', gtk.RESPONSE_OK)
        )
        
        dialog.set_size_request(260, 140)
        dialog.set_border_width(10)
        dialog.vbox.pack_start(text)
        
        dialog.run()
        dialog.destroy()
    
    # encerra o mainloop
    def sair(self, widget):
        gtk.main_quit()
        