#!/usr/bin/env python

import sys
import codecs
from PyQt4 import QtCore, QtGui

mac = sys.platform.startswith("darwin")

class LaunchProb(QtGui.QApplication):

    loadFile = QtCore.pyqtSignal("QString")

    def __init__(self, argv):
        super(LaunchProb, self).__init__(argv)
        self.setApplicationName("LaunchProb")

    def event(self, e):
        if e.type() == QtCore.QEvent.FileOpen:
            self.loadFile.emit(e.file())
            return True
        return super(LaunchProb, self).event(e)


class MainWindow(QtGui.QMainWindow):
    def __init__(self, parent = None):
        super(MainWindow, self).__init__(parent)
        self.setAttribute(QtCore.Qt.WA_DeleteOnClose)
        self.filename = QtCore.QString()
        # create parentless menu bar for the Mac
        if mac:
            self.menuBar = QtGui.QMenuBar()
        else:
            self.menuBar = self.menuBar()

        quit = QtGui.QAction("Quit", self)
        quit.setShortcut("Ctrl+Q")
        quit.setMenuRole(QtGui.QAction.QuitRole)
        self.connect(quit, QtCore.SIGNAL("triggered()"), self.close)
        fileMenu = self.menuBar.addMenu("File")
        fileMenu.addAction(quit)

        self.textEdit = QtGui.QTextEdit(self)
        self.setCentralWidget(self.textEdit)

        QtGui.QApplication.instance().loadFile.connect(self.loadFile)

        self.show()

    def loadFile(self, filename):
        fp = None
        exception = None
        try:
            fp = codecs.open(unicode(filename), "Ur", "macroman", "ignore")
            self.textEdit.setPlainText(fp.read())
            self.textEdit.document().setModified(False)
            self.newlines = fp.newlines
        except IOError, e:
            exception = e
        finally:
            if fp is not None:
                fp.close()
            if exception is not None:
                raise exception

if __name__ == "__main__":
    app = LaunchProb(sys.argv)
    win = MainWindow()
    ret = app.exec_()
    sys.exit(ret)
