#!/bin/bash -x

[ "$1" = "-release" -o "$1" = "-debug" ] || {
    echo "usage: $0 -release|-debug"
    exit 1
}

type -p svn &> /dev/null || {
    echo "$0: please install svn"
    exit 1
}

mode=${1:-}

[ -d pyinstaller ] || svn co http://svn.pyinstaller.org/trunk pyinstaller

pushd pyinstaller

[ -f source/linux/Makefile ] || {
	pushd source/linux
	python Make.py
	sed -i '' 's/min=10.3/min=10.4/g' Makefile
	make
	popd
}

python Configure.py

popd

pyinstaller/Build.py LaunchProb${mode}.spec

rm -rf LaunchProb.app

mkdir -p LaunchProb.app

cp -prv Contents LaunchProb.app

cp -prv dist/LaunchProb LaunchProb.app/Contents/MacOS

echo "LaunchProb.app built successful"

