"""
/* SearchFiles.py
 *
 * Copyright (c) 2005 Mohanaraj Gopala 
 * Based on work by Douglass R. Cutting from the Lucene project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
"""
import PyLucene, sys,getopt,os

class SearchFiles :
    def __init__(self,index,queryArgs):
        try :
            searcher = PyLucene.IndexSearcher(index)
            analyzer = PyLucene.StopAnalyzer()

            for queryString in queryArgs:
	            print "Query:",queryString

	            queryObject = PyLucene.QueryParser.parse(queryString, "contents", analyzer)
	            print "Searching for: ",queryString

	            hits = searcher.search(queryObject)
	            print len(hits)," total matching documents"

	            self.HITS_PER_PAGE = 10

	            for start in range(0,len(hits),self.HITS_PER_PAGE):
	                end = min(len(hits), start + self.HITS_PER_PAGE)
	                for i in range(start,end):
	                    print hits.doc(i).url

	                if len(hits) > end :
	                    answer=raw_input("more (y/n) ? ")
	                    if (len(answer) == 0 or answer[0] == 'n'):
	                        break

            searcher.close();

        except Exception,e:
            print "Failed: ", e
            
def usage():
    print "SearchFiles.py [--index <index>] search_query1 search_query2 ....."

def run(index,query):
    try:
        SearchFiles(index,query)
    except Exception, e:
        print "Failed: ", e

if __name__ == '__main__':
    if len(sys.argv) < 1:
        usage()
    else:
        try:
            opts, args = getopt.getopt(sys.argv[1:], "i:", [ "index="])
            index=False
            
            if len(args) < 1:
                print "Wrong arguments passed for search_query argument(s)"
                usage()
                sys.exit(2)
            else :
                query=args
                if len(query)<1:
                    print "Query cannot be blank"
                    usage()
                    sys.exit(2)

            for options, argument in opts:
                if options in ('-i','--index'):
                    if not os.path.exists(argument):
                        print 'The path to the index file "'+argument+'" is not valid'
                        usage()
                        sys.exit(2)
                    else:
                        index=argument
                
            if index==False and not os.path.exists(os.path.abspath('./index')):
                    print 'The path to the index file was not found'
                    usage()
                    sys.exit(2)
            else :
                index=os.path.abspath('./index')
            run(index,query)

        except getopt.GetoptError,e:
            # print help information and exit:
            usage()
            sys.exit(2)
