#!/usr/bin/env python

import sys, os, string, traceback
from qt import *

from testui import TestUI

def mainExceptHook(exc_type, exc_value, exc_traceback):
    msg = string.joinfields(traceback.format_exception(exc_type, exc_value, exc_traceback))
    QMessageBox.critical(None,
        qApp.tr("Oops"),
        qApp.tr("An unexpected exception has been occured:\n\n"
                "%1\n"
                "Please report this problem to:\n"
                "Hans-Peter Jansen (hpj@urpla.net)\n\n"
                "The application will terminate now.\n").arg(msg),
        QMessageBox.Ok,
        QMessageBox.NoButton,
        QMessageBox.NoButton)

    # Call the default exception handler
    sys.__excepthook__(exc_type, exc_value, exc_traceback)
    sys.exit(1)


# install a new exception handler
def setExpHandler():
    sys.excepthook = mainExceptHook


def loadTrans(dirs, t):
    trans = QTranslator(None)
    for dir in dirs:
        loaded = trans.load(t, dir)
        if loaded:
            return trans
    return None


if __name__ == "__main__":
    app = QApplication(sys.argv)

    # prepare translation
    curdir = os.path.dirname(sys.argv[0])
    if not curdir:
        curdir = '.'
    # check current locale
    loc = str(QTextCodec.locale())
    if loc != "C":
         # setup the searchpath for qt
        dirs = [curdir, "."]
        qtdir = os.getenv("QTDIR")
        if qtdir is not None:
            dirs.insert(-1, os.path.join(qtdir, "translations"))

        qtTrans = loadTrans(dirs, "qt_" + loc)
        if qtTrans:
            print "install: qt_%s" % loc
            app.installTranslator(qtTrans)

        myTrans = loadTrans(dirs, "test_" + loc)
        if myTrans:
            print "install: test_%s" % loc
            app.installTranslator(myTrans)

    #setExpHandler()
    win = TestUI()
    QObject.connect(app, SIGNAL("lastWindowClosed()"), app, SLOT("quit()"))
    app.setMainWidget(win)
    win.show()
    ret = app.exec_loop()
    #print "MainWidget returned:", ret
    sys.exit(ret)

