#!/usr/bin/env python
###########################################################################
#
# Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# PyQt port in October 2010 by Hans-Peter Jansen <hpj@urpla.net>
#
###########################################################################

# This is only needed for Python v2 but is harmless for Python v3.
import sip
sip.setapi('QString', 2)        # converts QStrings to unicode objects internally
sip.setapi('QVariant', 2)       # converts QVariants to the basic data type internally

from PyQt4 import QtCore, QtGui

from stardelegate import StarDelegate
from starrating import StarRating
from stareditor import StarEditor

def populateTableWidget(tableWidget):
    staticData = (
        ("Mass in B-Minor", "Baroque", "J.S. Bach", 5),
        ("Three More Foxes", "Jazz", "Maynard Ferguson", 4),
        ("Sex Bomb", "Pop", "Tom Jones", 3),
        ("Barbie Girl", "Pop", "Aqua", 5),
    )
    row = 0
    for title, genre, artist, rating in staticData:
        item0 = QtGui.QTableWidgetItem(title)
        item1 = QtGui.QTableWidgetItem(genre)
        item2 = QtGui.QTableWidgetItem(artist)
        item3 = QtGui.QTableWidgetItem()
        item3.setData(0, StarRating(rating))
        tableWidget.setItem(row, 0, item0)
        tableWidget.setItem(row, 1, item1)
        tableWidget.setItem(row, 2, item2)
        tableWidget.setItem(row, 3, item3)
        row += 1


if __name__ == "__main__":
    import sys, codecs
    sys.stdout = codecs.lookup("utf8")[-1](sys.stdout, 'ignore')
    app = QtGui.QApplication(sys.argv)
    tableWidget = QtGui.QTableWidget(4, 4)
    tableWidget.setItemDelegate(StarDelegate())
    tableWidget.setSelectionBehavior(QtGui.QAbstractItemView.SelectRows)
    headerLabels = ("Title", "Genre", "Artist", "Rating")
    tableWidget.setHorizontalHeaderLabels(headerLabels)
    populateTableWidget(tableWidget)
    # I don't like this behaviour
    #tableWidget.setEditTriggers(QtGui.QAbstractItemView.DoubleClicked
    #                            | QtGui.QAbstractItemView.SelectedClicked)
    tableWidget.setEditTriggers(QtGui.QAbstractItemView.DoubleClicked)
    tableWidget.resizeColumnsToContents()
    tableWidget.resize(500, 300)
    tableWidget.show()
    ret = app.exec_()
    # get the data out of the model
    data = []
    model = tableWidget.model()
    for row in range(model.rowCount()):
        coldata = []
        for col in range(model.columnCount()):
            index = model.index(row, col)
            value = model.data(index, QtCore.Qt.DisplayRole)
            if isinstance(value, basestring):
                coldata.append(value)
            else:
                coldata.append(repr(value))
        data.append(", ".join(coldata))
    print "\n".join(data)
    sys.exit(ret)
