###########################################################################
#
# Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# PyQt port in October 2010 by Hans-Peter Jansen <hpj@urpla.net>
#
###########################################################################

from PyQt4 import QtCore, QtGui

from starrating import StarRating
from stareditor import StarEditor

class StarDelegate(QtGui.QStyledItemDelegate):
    def __init__(self, parent = None):
        super(StarDelegate, self).__init__(parent)

    def paint(self, painter, option, index):
        starRating = index.data()
        if isinstance(starRating, StarRating):
            if option.state & QtGui.QStyle.State_Selected:
                painter.fillRect(option.rect, option.palette.highlight())
            starRating.paint(painter, option.rect, option.palette,
                             StarRating.ReadOnly)
        else:
            super(StarDelegate, self).paint(painter, option, index)

    def sizeHint(self, option, index):
        starRating = index.data()
        if isinstance(starRating, StarRating):
            return starRating.sizeHint()
        else:
            return super(StarDelegate, self).sizeHint(option, index)

    def createEditor(self, parent, option, index):
        starRating = index.data()
        if isinstance(starRating, StarRating):
            editor = StarEditor(parent)
            editor.editingFinished.connect(self.commitAndCloseEditor)
            return editor
        else:
            return super(StarDelegate, self).createEditor(parent, option, index)

    def setEditorData(self, editor, index):
        starRating = index.data()
        if isinstance(starRating, StarRating):
            editor.setStarRating(starRating)
        else:
            super(StarDelegate, self).setEditorData(editor, index)

    def setModelData(self, editor, model, index):
        starRating = index.data()
        if isinstance(starRating, StarRating):
            model.setData(index, editor.starRating())
        else:
            super(StarDelegate, self).setModelData(editor, model, index)

    def commitAndCloseEditor(self):
        self.commitData.emit(self.sender())
        self.closeEditor.emit(self.sender())
