###########################################################################
#
# Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# PyQt port in October 2010 by Hans-Peter Jansen <hpj@urpla.net>
#
###########################################################################
from PyQt4 import QtCore, QtGui

from starrating import StarRating

class StarEditor(QtGui.QWidget):

    editingFinished = QtCore.pyqtSignal()

    def __init__(self, parent = None):
        super(StarEditor, self).__init__(parent)
        self._starRating = None
        self.setMouseTracking(True)
        self.setAutoFillBackground(True)

    def setStarRating(self, starRating):
        self._starRating = starRating

    def starRating(self):
        return self._starRating

    def sizeHint(self):
        return self._starRating.sizeHint()

    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        self._starRating.paint(painter, self.rect(), self.palette(), StarRating.Editable)

    def mouseMoveEvent(self, event):
        star = self.starAtPosition(event.x())
        if star != self._starRating.starCount() and star != -1:
            self._starRating.setStarCount(star)
            self.update()

    def mouseReleaseEvent(self, event):
        self.editingFinished.emit()

    def starAtPosition(self, x):
        # enable a star, if pointer crosses the center horizontally
        starwidth = self._starRating.sizeHint().width() / self._starRating.maxStarCount()
        star = (x + starwidth / 2) / starwidth
        if 0 <= star <= self._starRating.maxStarCount():
            return star
        return -1

if __name__ == "__main__":
    import sys
    app = QtGui.QApplication(sys.argv)
    win = QtGui.QWidget()
    layout = QtGui.QVBoxLayout()
    for i in range(1, 6):
        starEditor = StarEditor()
        starEditor.setStarRating(StarRating(i))
        layout.addWidget(starEditor)
    win.setLayout(layout)
    win.show()
    sys.exit(app.exec_())
