###########################################################################
#
# Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# PyQt port in October 2010 by Hans-Peter Jansen <hpj@urpla.net>
#
###########################################################################
import math
from PyQt4 import QtCore, QtGui

class StarRating(object):
    # enum EditMode
    Editable, ReadOnly = range(2)
    PaintingScaleFactor = 20

    def __init__(self, starCount, maxStarCount = 5):
        self._starCount = starCount
        self._maxStarCount = maxStarCount
        self.starPolygon = QtGui.QPolygonF([QtCore.QPointF(1.0, 0.5)])
        for i in range(5):
            self.starPolygon << QtCore.QPointF(0.5 + 0.5 * math.cos(0.8 * i * 3.14),
                                               0.5 + 0.5 * math.sin(0.8 * i * 3.14))

        self.diamondPolygon = QtGui.QPolygonF()
        self.diamondPolygon << QtCore.QPointF(0.4, 0.5) \
                            << QtCore.QPointF(0.5, 0.4) \
                            << QtCore.QPointF(0.6, 0.5) \
                            << QtCore.QPointF(0.5, 0.6) \
                            << QtCore.QPointF(0.4, 0.5)

    def starCount(self):
        return self._starCount

    def maxStarCount(self):
        return self._maxStarCount

    def setStarCount(self, starCount):
        self._starCount = starCount

    def setMaxStarCount(self, maxStarCount):
        self._maxStarCount = maxStarCount

    def sizeHint(self):
        return self.PaintingScaleFactor * QtCore.QSize(self._maxStarCount, 1)

    def paint(self, painter, rect, palette, editMode):
        painter.save()
        painter.setRenderHint(QtGui.QPainter.Antialiasing, True)
        painter.setPen(QtCore.Qt.NoPen)
        if editMode == StarRating.Editable:
            painter.setBrush(palette.highlight())
        else:
            painter.setBrush(palette.foreground())

        yOffset = (rect.height() - self.PaintingScaleFactor) / 2
        painter.translate(rect.x(), rect.y() + yOffset)
        painter.scale(self.PaintingScaleFactor, self.PaintingScaleFactor)
        for i in range(self._maxStarCount):
            if i < self._starCount:
                painter.drawPolygon(self.starPolygon, QtCore.Qt.WindingFill)
            elif editMode == StarRating.Editable:
                painter.drawPolygon(self.diamondPolygon, QtCore.Qt.WindingFill)
            painter.translate(1.0, 0.0)
        painter.restore()

    def __repr__(self):
        return "StarRating(%s)" % self._starCount
