#include "Python.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"

const char *MainWindow::CATCH_PYTHON_OUTPUT ="import sys\n"\
											"class CatchOutErr():\n"\
											"	def __init__(self):\n"\
											"		self.value = ''\n"\
											"	def write(self, txt):\n"\
											"		self.value += txt\n"\
											"catchOutErr = CatchOutErr()\n"\
											"sys.stdout = catchOutErr\n"\
											"sys.stderr = catchOutErr\n";

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
	ui(new Ui::MainWindow),
	lexer(0)
{
    ui->setupUi(this);
	lexer = new QsciLexerPython(ui->console);
	ui->console->setLexer(lexer);
	connect(ui->run, SIGNAL(clicked()), this, SLOT(run()));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::run()
{
	ui->terminal->setText("");
	QString program = ui->console->text();
	Py_Initialize();
	PyObject *module = PyImport_AddModule("__main__");
	if (module)
	{
		PyObject *globals = PyModule_GetDict(module);
		if (globals)
		{
			PyObject *locals = PyDict_New();
			PyRun_SimpleString(CATCH_PYTHON_OUTPUT);
			PyObject *catcher = PyObject_GetAttrString(module, "catchOutErr");
			if (catcher)
			{
				PyRun_String(program.toUtf8(), Py_file_input, globals, locals);
				PyErr_Print();
				PyObject *output = PyObject_GetAttrString(catcher,"value");
				if (output)
				{
					QString output_str(PyString_AsString(output));
					ui->terminal->setText(output_str);
				}
			}
		}
	}
	Py_Finalize();
}
