import tables
import netCDF4
import glob
import os

array_atom = tables.Float32Atom()

def convert(filename, complib):
    
    filters = tables.Filters(complevel=9, complib=complib)
    f = netCDF4.Dataset(filename)
    fid = tables.openFile(filename[:-2]+"h5-"+complib,"w")
    for array_name in f.variables:
        data = f.variables[array_name][:]
        field = fid.createCArray(fid.root, array_name, array_atom, data.shape, filters=filters)
        field[:] = data[:]

    fid.close()
    f.close()

if __name__ == "__main__":
    
    os.system('cp may8rc_zvd.001.nc may8rc_zvd.002.nc')
    files = glob.glob("./may8rc_zvd.0*.nc")
    for filename in files:
        #for complib in ('zlib', 'blosc'):
        for complib in ('blosc', 'zlib'):
            convert(filename, complib)

    os.system('ptrepack --complib="blosc" --complevel=9 -o may8rc_zvd.002.h5-blosc may8rc_zvd.002.h5-blosc-ptrepack')
