import numarray
from tables import *

# Create an instance of HDF5 file
fileh = openFile("array.h5", mode = "w")
root = fileh.root

# Create some group objects
group1 = fileh.createGroup(root, 'group1', "Group 1")

group2 = fileh.createGroup(root, 'group2', "Group 2")
                
# Create some dimension scale objects
        
atom1 = Atom(shape=(0,), flavor="NumArray")
atom2 = Atom(shape=(0,), flavor="NumArray")
atom3 = Atom(shape=(3,0), flavor="NumArray")
atom5 = Atom(shape=(0,3), flavor="NumArray")

filters = Filters(complevel=5, complib='zlib')
        
ds1 = fileh.createDimensionScale(root, 'ds1', atom1,
                                 "Title for Dimension Scale 1",
                                 None, 10, None, None,
                                 "attribute 'NAME'")
ds1.append([1,1,1])

ds2 = fileh.createDimensionScale(group1, 'ds2', atom2,
                                 "Title for Dimension Scale 2",
                                 filters, 10, None, None)
ds2.append(numarray.array([2]*2))

ds3 = fileh.createDimensionScale(root, 'ds3', atom3)
ds3.append(numarray.array([[3]*2]*3))
        
# Create some array objects
data4 = fileh.createArray(root, 'data4',
                          [3,3,3],
                          "Array 4")

data5 = fileh.createEArray(group2, 'data5', atom5)
data5.append(numarray.array([[5]*3]*2))

ds1.attach_to(data4, 0)
ds1.attach_to(data5, 1)
ds2.attach_to(data5, 0)
ds3.attach_to(data5, 1)

print data5.attrs.DIMENSION_LIST
print data5.attrs.DIMENSION_LIST
