#!/usr/bin/env python

import serial
import time
import usb
import glob
import sys

import string
from ctes_ds1631 import *



def ftdi():
    """Busca la placa Arduino Nano en el bus usb
    Devuelve la especificacion del dispositivo.
    """
    return any(dev.idVendor == 1027 and dev.idProduct == 24577 
        for bus in usb.busses() for dev in bus.devices)

def puertos( id):
    """Busca el puerto serie en donde esta conectada la placa
    Arduino Nano.
    
    Entrada-> identificador del dispositivo buscado.
    Salida-> puerto en el que esta conectado. En caso de
    no encontralo, devuelve False.
    """
    for i in glob.glob('/dev/ttyUSB*'):
        try:
            Puerto= serial.Serial( i, 19200, timeout= 1)
        except:
            Existe= 0
        else:
            Puerto.write("?")
            idPort= Puerto.readline(None, "\r")
            idP= "%s\r" % id
            if idPort== idP:
                Puerto.close()
        
                return i
            else:
                return False


def device_command( id, Comando, Valor):
    """Controla las comunicaciones con el dispositivo.
    
    Valores de entrada:
    
    id------- Identificador unico de cada dispositivo
    Comando-- Comando a ejecutar en el dispositivo puede ser de lectura o escritura
    Valor---- valor que se desea enviar al dispositivo.
    
    Es responsabilidad del usuario enviar la informacion correctamente tipeada.
    """
    comandos_lectura=['?', 'T', 't', 'H', 'L', 'C']
    comandos_escritura=['h', 'l', 'c', 'r']
    idFound= False
    
    if ftdi():
        puerto= puertos( id)
        if puerto != 0:
            try:
                PuertoSerie= serial.Serial(puerto, 19200, timeout= 1)
                idFound= True
               
            except:
               
                idFound= False
        else:
            
            idFound= False
    else:
        
        idFound= False
    
    
    if Comando in comandos_lectura:
        
        if Comando== 'T':
            """Prueba de comentario"""
            if idFound:
                PuertoSerie.write("T")
                Temp= PuertoSerie.readline( None, "\r")
                PuertoSerie.close()
                return Temp
            else:
                return False
            
        if Comando== 't':
            """Prueba de comentario"""
            if idFound:
                PuertoSerie.write("t")
                Temp= PuertoSerie.readline( None, "\r")
                PuertoSerie.close()
                return Temp
            else:
                return False
        
        if Comando== 'H':
            if idFound:
                PuertoSerie.write("H")
                TH= PuertoSerie.readline( None, "\r")
                PuertoSerie.close()
                return TH
            else:
                print "Error, dispositivo no encontrado"
                return False
        
        if Comando== 'L':
            if idFound:				
                PuertoSerie.write("L")
                TL= PuertoSerie.readline( None, "\r")
                PuertoSerie.close()
                return TL
            else:
                print "Error, dispositivo no encontrado"
                return False
        
        if Comando== 'C':
            if idFound:
                PuertoSerie.write("C")
                Config= PuertoSerie.readline( None, "\r")
                PuertoSerie.close()
                return Config
            else:
                print "Error, dispositivo no encontrado"
                return False
        
    if Comando in comandos_escritura:
        
        if Comando== 'h':
            if idFound:
                PuertoSerie.write("h")
                PuertoSerie.write( Valor)
                PuertoSerie.close()
                return True
            else:
                print "Error, dispositivo no encontrado"
                return False
                
        if Comando== 'l':
            if idFound:
                PuertoSerie.write("l")
                PuertoSerie.write( Valor)
                PuertoSerie.close()
                return True
            else:
                print "Error, dispositivo no encontrado"
                return False
            
        if Comando== 'c':
            if idFound:
                PuertoSerie.write("c")
                PuertoSerie.write( Valor)
                PuertoSerie.close()
                return True
            else:
                print "Error, dispositivo no encontrado"
                return False
        
        if Comando== 'r':
            if idFound:
                PuertoSerie.write("r")
                PuertoSerie.close()
                return True
            else:
                print "Error, dispositivo no encontrado"
                return False
            
def Get_Temp( id):
   return device_command( id, 't', 0)

if __name__ == "__main__":
    print Get_Temp( idDevice)
