#! /usr/bin/env python

import gtk
import gtk.gdk
from math import sin, cos, tan, pi, radians, degrees
from Get_Temp import Get_Temp
from ctes_ds1631 import *
import gobject
class Gauge( gtk.DrawingArea):
    def __init__(self):
        gtk.DrawingArea.__init__(self)
            
        self.connect("expose-event", self.expose)
        gobject.timeout_add( 1000, self.temporizador)
    
    def expose(self, widget, event):
        try:
            self.area = event.area            
        except:
            pass
        self.crea_tapiz()
        self.dibuja( self.cairo)
        return False

    def crea_tapiz( self):
        self.cairo= self.window.cairo_create()
        self.cairo.rectangle(self.area.x, self.area.y,
                self.area.width, self.area.height)

        self.cairo.clip()
        return True
    
    def temporizador( self):

        self.crea_tapiz()
        self.dibuja( self.cairo)
        return True
        

    def dibuja( self, cr):
       

        tapiz= self.get_allocation()
        width= tapiz.width
        height= tapiz.height
        
        
        radius = min(width, height)/ 2.0
        circulo_central= radius/ 5.0
        circulo_superior= radius/ 6.0
        nu= radians( 45.0)
        centro_x= width/ 2.0
        centro_y= height/ 2.0
        factor_a= 4.0
        factor_b= 5.0
        L= radius- radius/ factor_a
        
        Temperatura= float(Get_Temp( idDevice))
        
        angulo= (2*pi) -( Temperatura* pi/ 70)
        
        ax= L* cos( angulo)
        ay= L* sin( angulo)
        
        alfa= angulo+ nu/2
                
        dx= L/ factor_b * cos( alfa)
        dy= L/ factor_b * sin( alfa)
        
        r= radius- radius/ factor_a
        r1=radius- (radius/ factor_b/2)
        r2= radius- radius/ factor_b
        
        
        cr.set_source_rgb(0.5, 0.5, 0.5)
        cr.rectangle(0, 0, width, height)
        cr.fill()
        
        
        
        cr.set_source_rgb(1.0, 0.0, 0.8)
        cr.arc( centro_x, centro_y, r1, 0, 2*pi)        
        cr.fill()
        cr.set_source_rgb(1.0, 2.0, 0.8)
        cr.arc( centro_x, centro_y, r2, 0, 2*pi)
        cr.fill()
        cr.stroke()        
         
        cr.set_source_rgb(1.0, 0.0, 0.8)
        
        for q in range( 0, 360, 13):
            i= radians( q)
        
            Ax= centro_x- ( r2 * cos ( i))
            Ay= centro_y- ( r2 * sin ( i))
            
            Bx= centro_x- ( r * cos( i))
            By= centro_y- ( r * sin( i))
            
            cr.move_to( Ax, Ay)
            cr.line_to( Bx, By)      
        cr.stroke()
        
        cr.set_source_rgb(1.0, 0.0, 0.8)
        cr.arc( centro_x, centro_y, L/ factor_b, angulo+ nu/2, angulo- nu/2)
        cr.line_to( centro_x+ ax, centro_y+ ay)
        cr.line_to( centro_x+ dx, centro_y+ dy)
        cr.fill()
        cr.stroke()
        
        
        
        return True
    
def main():
    Ventana= gtk.Window()
    dial= Gauge()
    Ventana.add( dial)
    Ventana.connect("destroy", gtk.main_quit)
    Ventana.show_all()
    gtk.main()
    
if __name__ == "__main__" :
    main()