/**********************************************************************************************
    Copyright (C) 2014 Oliver Eichler oliver.eichler@gmx.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**********************************************************************************************/

#include "CPanningSetup.h"
#include "IMouse.h"


CPanningSetup::CPanningSetup(QWidget *parent)
    : QDialog(parent)
{
    setupUi(this);
    
    // PanSensitivityPC in percentage [0..100], PanSensitivity [0...1]
    int PanSensitivityPC = IMouse::getPanSensitivity() * 100.;
    PannSensSL->setMinimum(10);
    PannSensSL->setMaximum(100);
    PannSensSL->setSingleStep(5);
    PannSensSL->setValue(PanSensitivityPC);
    
    QString str;
    PannSensLE->setText(str.setNum(PanSensitivityPC));
    PannSensLE->setDisabled(true);
    connect(PannSensSL, SIGNAL(valueChanged(int)), this, SLOT(slotPanSensitivityChgd(int)));
}

CPanningSetup::~CPanningSetup()
{
}

void CPanningSetup::slotPanSensitivityChgd(int sensitivity)
{
    QString str;
    PannSensLE->setText(str.setNum(sensitivity));
}

void CPanningSetup::accept()
{
    int PanSensitivityPC = PannSensSL->value();
    IMouse::setPanSensitivity(0.01 * PanSensitivityPC); 
    QDialog::accept();
}
