/* ************************************************************************

   Copyright:

   License:

   Authors:

************************************************************************ */

/* ************************************************************************

#asset(test/*)

************************************************************************ */

/**
 * This is the main application class of your custom application "test"
 */
qx.Class.define("test.Application",
{
  extend : qx.application.Standalone,



  /*
  *****************************************************************************
     MEMBERS
  *****************************************************************************
  */

  members :
  {
    /**
     * This method contains the initial application code and gets called
     * during startup of the application
     */
    main : function()
    {
      // Call super class
      this.base(arguments);

      // Enable logging in debug variant
      if (qx.core.Variant.isSet("qx.debug", "on"))
      {
        // support native logging capabilities, e.g. Firebug for Firefox
        qx.log.appender.Native;
        // support additional cross-browser console. Press F7 to toggle visibility
        qx.log.appender.Console;
      }

      /*
      -------------------------------------------------------------------------
        Below is your actual application code...
      -------------------------------------------------------------------------
      */

        // Document is the application root
        var doc = this.getRoot();
        var graphBox =
            new qx.ui.container.Composite(new qx.ui.layout.VBox().set({
                spacing: 20})).set({
                                       padding: 0,
                                       width:500,
                                       height:400});
        doc.add(graphBox);

        var graphCanvas =
            new qx.ui.container.Composite(new qx.ui.layout.Canvas()).set({
                                       padding: 0,
                                       width:500,
                                       height:400});

        var graphButton = new  qx.ui.form.Button("Plot");
        graphButton.setMaxWidth(50);
        var myGraph = null;

        graphButton.addListener("execute",
            function(e) {
                var dom = graphCanvas.getContainerElement().getDomElement();
                qx.bom.element.Attribute.set(dom, 'id', 'AgrammonJqplotBox');
                var data = [['frogs',3], ['buzzards',7], ['deer',2.5],
                            ['turkeys',6], ['moles',5], ['ground hogs',4]];

                myGraph =
                 jQuery.jqplot('AgrammonJqplotBox', [data],
                              {
                                title: { text: 'Testing jqPlot',
                                         fontSize: '12pt'},
                                seriesDefaults:{
                                    renderer:jQuery.jqplot.PieRenderer,
                                    rendererOptions:{sliceMargin:8
                                                    }
                                },
                                legend:{show:true, fontSize: '8pt'},
                                // disable cursor
                                cursor:{zoom:false, showTooltip:false,
                                        followMouse: false,
                                        clickReset:false}
                              });
                myGraph.redraw();
            }, this);

        graphBox.add(graphButton);
        graphBox.add(graphCanvas);

    }
  }
});
