/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
#ifndef _Subscription_
#define _Subscription_

#include <qpid/client/Dispatcher.h>
#include <qpid/client/Session.h>
#include <qpid/client/MessageListener.h>
#include <set>
#include <sstream>

using namespace qpid::client;

class SubscriptionManager
{
    std::set<std::string> subscriptions;
    qpid::client::Dispatcher dispatcher;
    qpid::client::Session& session;
    uint counter;

    std::string nextTag();
public:
    SubscriptionManager(Session& session);
    std::string subscribe(std::string queue, MessageListener& listener);
    void cancel(const std::string tag);
    qpid::client::Dispatcher& getDispatcher() { return dispatcher; }
    size_t subscriptionCount() { return subscriptions.size(); }
    void run();
    void stop();
};

SubscriptionManager::SubscriptionManager(Session& s) : dispatcher(s), session(s), counter(0) {}

std::string SubscriptionManager::subscribe(std::string queueName, MessageListener& listener)
{
    std::string tag = nextTag();
    session.messageSubscribe_(queue=queueName, destination=tag);
    session.messageFlow_(destination=tag, unit=0, value=1);//messages
    session.messageFlow_(destination=tag, unit=1, value=0xFFFFFFFF);//bytes
    dispatcher.listen(tag, &listener);    
    subscriptions.insert(tag);
    return tag;
}

std::string SubscriptionManager::nextTag()
{
    std::stringstream tag;
    tag << "subscriber" << ++counter;    
    return tag.str();    
}

void SubscriptionManager::cancel(const std::string tag)
{
    if (subscriptions.erase(tag)) {
        session.messageCancel_(destination=tag);
        dispatcher.cancel(tag);
    }
}

void SubscriptionManager::run()
{
    dispatcher.stop();
}

void SubscriptionManager::stop()
{
    dispatcher.stop();
}

#endif
