
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;

import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;

public class JMSSample
{    
    static String queueName = "message_queue";
    static String broker_server = "localhost";
    static int broker_port = 5672;
    static String broker_login = "guest";
    static String broker_password = "guest";
    
    public static void main(String[] args) {
        try {
                // Create a connection to the broker
                System.out.println("Connecting to broker: " + 
                        "tcp://" + broker_server + ":" + broker_port);
                
                Connection connection = new AMQConnection(broker_server, broker_port,
                        broker_login, broker_password, "clientid/test", "");
                
                connection.start();
                Session session = connection.createSession(false,Session.AUTO_ACKNOWLEDGE);
                System.out.println("Creating a session");              
  
                // ---------------- Queue -----------------------------
                Destination destinationQueue = new AMQQueue("amq.direct","weather");
                                               
                MessageProducer producerQueue = session.createProducer(destinationQueue);
                System.out.println("Creating a Message Producer for dest " + destinationQueue);

                TextMessage txtQueueMsg = session.createTextMessage();
                txtQueueMsg.setText("Hello Queue");
                
                producerQueue.send(txtQueueMsg);
                System.out.println("Sending message");
                
                MessageConsumer consumerQueue = session.createConsumer(destinationQueue);
                System.out.println("Creating a Message Consumer for dest " + destinationQueue);
                Message msgQueue = consumerQueue.receive();
                msgQueue.acknowledge();   
                System.out.println("Receiving message " + msgQueue);
                System.out.println("==================================================");
                
                // ---------------- Topic -----------------------------
/*                

	Commented out since this hangs reliably

                Destination destinationTopic = new AMQTopic((AMQConnection)connection,"weather.us");
                                
                MessageProducer producerTopic = session.createProducer(destinationTopic);
                System.out.println("Creating a Message Producer for dest " + destinationTopic);
                TextMessage txtTopicMsg = session.createTextMessage();
                txtTopicMsg.setText("Hello Topic");
                
                producerTopic.send(txtTopicMsg);
                System.out.println("Sending message");

                MessageConsumer consumerTopic = session.createConsumer(destinationTopic);
                System.out.println("Creating a Message Consumer for dest " + destinationTopic);
                Message msgTopic = consumerTopic.receive();
                msgTopic.acknowledge(); 
                System.out.println("Receiving message " + msgTopic);
                System.out.println("==================================================");
                               
  */                              
                // ---------------- Message Listener -----------------
                final Object monitor = new Object();

                consumerQueue.setMessageListener(new MessageListener()
                {
                   public void onMessage(Message msg)
                   {
                       System.out.println("Receiving message through Listerner " + msg);
                       try{
                           msg.acknowledge();
                       }catch(Exception e)
                       {
                          e.printStackTrace();
                       } 
                       synchronized(monitor)
                       {  
                  	 monitor.notifyAll();
                       }
                   }
                });
                
                TextMessage txtMsg = session.createTextMessage();
                txtMsg.setText("Message Listener Hello");
                
                producerQueue.send(txtMsg);
                System.out.println("Sending message for listener");
                synchronized(monitor)
                {  
                  monitor.wait();
                }
                System.out.println("Closing session and Connection");
                session.close();
                connection.close();
                
        }catch(Exception e){
            e.printStackTrace();
        }
    }
        
}
