/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.AMQException;
import org.apache.qpid.url.URLSyntaxException;

import javax.jms.*;

public class TemplateClass {

// Configuration for server and queue

  static String queueName = "message_queue";

  static String broker_server = "localhost";
  static int broker_port = 5672;
  static String broker_login = "guest";
  static String broker_password = "guest";

	public static void main(String[] args) {
		try {
			// Create a connection to the broker
			System.out.println("Connecting to broker: " + "tcp://" 
                               + broker_server + ":" + broker_port);
			Connection connection = new AMQConnection(broker_server, broker_port,
					broker_login, broker_password, "clientid/test", "");

			// Lookup a destination
			System.out.println("looking up destination: "
					+ queueName
					+ " on exchange amq.direct");
			Destination destination = new AMQQueue("amq.direct",
					queueName);

			// Start the connection and create a session
			connection.start();
			Session session = connection.createSession(false, 1);

			// ---------------------------------------------------------------

			// Do Something Here

			// ---------------------------------------------------------------

			// Clean up
			connection.close();
		} catch (JMSException e) {
			e.printStackTrace();
		} catch (AMQException e) {
            e.printStackTrace();
        } catch (URLSyntaxException e) {
            e.printStackTrace();  
        }
    }
}
