#include "mainwindow.h"
#include <QScriptEngine>
#include <QScriptEngineDebugger>
#include <QAction>
#include <QToolBar>
#include <QDockWidget>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    QWidget *pTmp;
    
    m_pEngine = new QScriptEngine(this);
    m_pDebugger = new QScriptEngineDebugger(this);
    
    m_pDebugger->attachTo(m_pEngine);
    m_pDebugger->setAutoShowStandardWindow(false);
    //m_pDebugger->action(QScriptEngineDebugger::RunToNewScriptAction);
    pTmp = m_pDebugger->widget(QScriptEngineDebugger::CodeWidget);
    pTmp->show();
    setCentralWidget(pTmp);
    
    pTmp = m_pDebugger->widget(QScriptEngineDebugger::DebugOutputWidget);
    QDockWidget *pDockOutput = new QDockWidget();
    pDockOutput->setWidget(pTmp);
    addDockWidget(Qt::BottomDockWidgetArea, pDockOutput);
    
    addToolBar(m_pDebugger->createStandardToolBar());
    
    QAction *m_pActionEvaluate = new QAction(tr("Evaluate"), this);
    QToolBar *pEvalBar = addToolBar("Eval");
    pEvalBar->addAction(m_pActionEvaluate);
    
    connect(m_pActionEvaluate, SIGNAL(triggered()), this, SLOT(sltEvaluate()));
}

MainWindow::~MainWindow()
{
}
    
void MainWindow::sltEvaluate()
{
    QString sScript = "print(\"Hello World\");";
    
    //m_pActionEvaluate->setEnabled(false);
    m_pEngine->evaluate(sScript, "test.js");
    //m_pActionEvaluate->setEnabled(true);
}


