#include <unistd.h>
#include <stdlib.h>

#include <Qt>
#include <QtGui>
#include <QInputDialog>

#include "mainwin.h"


void MainWindow::zoomIn()
{
   view->scale(2., 2.);
}

void MainWindow::zoomOut()
{
   view->scale(0.5, 0.5);
}



void MainWindow::createActions()
{
   zoomInAction = new QAction("Zoom In", this);
   connect(zoomInAction, SIGNAL(triggered()), SLOT(zoomIn()));

   zoomOutAction = new QAction("Zoom Out", this);
   connect(zoomOutAction, SIGNAL(triggered()), SLOT(zoomOut()));

   exitAction = new QAction(tr("E&xit"), this);
   connect(exitAction, SIGNAL(triggered()), app, SLOT(closeAllWindows()));
}


void MainWindow::createMenus( void )
{
   fileMenu = menuBar()->addMenu(tr("&File"));
   fileMenu->addAction(exitAction);
   viewMenu = menuBar()->addMenu(tr("&View"));
   viewMenu->addAction(zoomInAction);
   viewMenu->addAction(zoomOutAction);
}

void MainWindow::addItems( void )
{
   int        i, r, g, b;
   qreal      x,y;
   QPolygonF  poly(4);


   for (i=0; i < 2000; i++)
   {
      r = (int)((rand() / (double)RAND_MAX) * 255 + .5);
      g = (int)((rand() / (double)RAND_MAX) * 255 + .5);
      b = (int)((rand() / (double)RAND_MAX) * 255 + .5);

      QBrush fill(QColor(r,g,b));

      QGraphicsPolygonItem  *polygon = new QGraphicsPolygonItem;
      x = (qreal)((rand() / (double)RAND_MAX)  * 1000);
      y = (qreal)((rand() / (double)RAND_MAX)  * 1000);

      poly.clear();
      poly.append(QPointF(x, y));
      poly.append(QPointF(x - 20., y + 10));
      poly.append(QPointF(x, y + 20));
      poly.append(QPointF(x + 20,  y + 10));

      polygon->setPolygon(poly);
      polygon->setBrush(fill);
      polygon->setZValue((qreal)i);
      canvas->addItem(polygon); 
   }
}



MainWindow::MainWindow(QApplication *qt_app)
{
  app = qt_app;

  canvas = new QGraphicsScene;
  canvas->setSceneRect(0,0,1000,1000);

  view = new QGraphicsView(canvas, NULL);
  setCentralWidget(view);

  view->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
  view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOn);

  createActions();
  createMenus();

  addItems();
}
