#ifndef MAINWIN_H
#define MAINWIN_H

#include <QMainWindow>
#include <QApplication>
#include <QMenu>
#include <QAction>
#include <QGraphicsView>
#include <QGraphicsScene>


class MainWindow : public QMainWindow
{

   Q_OBJECT

public:
   MainWindow(QApplication *qt_app);

private slots:
   void zoomIn();
   void zoomOut();


private:
   void createActions();
   void createMenus();
   void addItems();

   QAction            *exitAction;
   QAction            *zoomInAction;
   QAction            *zoomOutAction;

   QMenu              *fileMenu;   
   QMenu              *viewMenu; 

   QApplication       *app;
   QString             file;

   QGraphicsView      *view;
   QGraphicsScene     *canvas;
   bool                firsttime;
};

#endif
