import java.io.*;
import javax.sound.sampled.*;

//jar cmf mainClass.txt playLinearAudioFile.jar *.class *.java

public class playAudioFile {

  static String lockFileName = new String(
                            System.getProperty("java.io.tmpdir") +
                            System.getProperty("file.separator") +
                            "audioplayer.lock");

  public static void main(String args[]) {

    String delOptStr = "--deleteAfterPlay";
    boolean argFlag = false;
    switch(args.length) {
      case 0:
        File lockFile = new File(lockFileName);
        if(lockFile.exists()) {
          lockFile.delete();
          System.exit(0);
        } else {
          usage();
        }
        break;
      case 1:
        new playAudioFile(args[0], false);
        break;
      case 2:
        if (args[0].equals(delOptStr)) {
          argFlag = true;
          new playAudioFile(args[1], true);
        }
        if (args[1].equals(delOptStr)) {
          argFlag = true;
          new playAudioFile(args[0], true);
        }
        if (argFlag == false) usage(); 
      default:
        usage();
    }
  }

  public static void usage() {
    System.err.println("\nplayLinearAudioFile.jar\nA Java (1.3 and up) command line tool\nto play back linear PCM sound files.");
    System.err.println("Hans-J. Bibiko 2008 bibiko@eva.mpg.de");
    System.err.println();
    System.err.println("Usage:");
    System.err.println("  java -jar playLinearAudioFile.jar {[OPTIONS] FILE}");
    System.err.println();
    System.err.println("  OPTIONS:");
    System.err.println("    --deleteAfterPlay    deletes the FILE after play-back");
    System.err.println("  FILE:");
    System.err.println("    - path to a sound file");
    System.err.println("    - supported formats:");
    System.err.println("      linear AIFC, AIFF, AU, SND, WAV");
    System.err.println("    - no argument will stop the current play-back if given");
    System.err.println("      otherwise it show this usage");
    System.err.println();
    System.exit(1);
  }

  public playAudioFile(String soundFileName, boolean deleteFileAfterStop) {

    AudioFormat       audioFormat;
    AudioInputStream  audioInputStream;
    SourceDataLine    sourceDataLine;
    String            theSoundFile;
    boolean           stopPlayback  = false;
    String            runFileName   = new String(
                                      System.getProperty("java.io.tmpdir") +
                                      System.getProperty("file.separator") +
                                      "audioplayer.run");
    File              runFile       = new File(runFileName);
    File              lockFile      = new File(lockFileName);

    byte tempBuffer[] = new byte[10000];
    try{
      File soundFile  = new File(soundFileName);
      if(lockFile.exists()) {
        lockFile.delete();
        int counter = 0;
        while(runFile.exists()) {
          Thread.sleep(40);
          counter += 1;  // for safety reasons break after 2.4secs
          if (counter > 60) {
            lockFile.delete();
            runFile.delete();
            break;
          }
        }
      }
      try{
        lockFile.createNewFile();
        runFile.createNewFile();
        while(lockFile.exists() == false) {Thread.sleep(40);}
        while(runFile.exists()  == false) {Thread.sleep(40);}
      } catch (Exception e) {
        lockFile.delete();
        runFile.delete();
        System.err.println("Could not create the lock/run file.");
        System.exit(1);
      }
      try{
        audioInputStream = AudioSystem.getAudioInputStream(soundFile.getAbsoluteFile());
        audioFormat = audioInputStream.getFormat();
        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
        sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
        sourceDataLine.open(audioFormat);
        sourceDataLine.start();
        int cnt;
        while(lockFile.exists() && runFile.exists() &&
            (cnt = audioInputStream.read(tempBuffer,0,tempBuffer.length)) != -1){
          if(cnt > 0) sourceDataLine.write(tempBuffer, 0, cnt);
        }
        sourceDataLine.drain();
        sourceDataLine.close();
        lockFile.delete();
        runFile.delete();
        if (deleteFileAfterStop) soundFile.delete();
        System.exit(0);
      }catch (Exception e) {
        lockFile.delete();
        runFile.delete();
        System.err.println("Could not read the sound file.");
        System.exit(1);
      }
    } catch (Exception e) {
      lockFile.delete();
      runFile.delete();
      System.err.println("Internal Error:");
      e.printStackTrace();
      System.exit(1);
    }
  }
}
