import sys
import rdkit.Chem as rd

if sys.argv[1]:
  fmcs_impl = sys.argv[1]
else:
  fmcs_impl = 'c++'

if fmcs_impl == 'c++':
  from rdkit.Chem.rdFMCS import FindMCS, AtomCompare, BondCompare
  _params = dict(maximizeBonds = False, threshold = 1.0,
                 verbose = False, matchValences = False,
                 ringMatchesRingOnly = True, completeRingsOnly = True,
                 atomCompare = AtomCompare.CompareAny,
                 bondCompare = BondCompare.CompareAny)

else:
  from rdkit.Chem.MCS import FindMCS
  _params = dict(minNumAtoms = 2, maximize = 'atoms', atomCompare = 'any',
                 bondCompare = 'any', matchValences = False,
                 ringMatchesRingOnly = True, completeRingsOnly = True,
                 threshold = None)

_params.update(timeout = int(sys.argv[2]))

mol1 = rd.MolFromMol2File('1.mol2', sanitize = False, removeHs = False)
mol2 = rd.MolFromMol2File('2.mol2', sanitize = False, removeHs = False)

mcs = FindMCS((mol1, mol2), **_params)

if fmcs_impl == 'c++':
  smarts = mcs.smartsString
  canceled = mcs.canceled
else:
  smarts = mcs.smarts
  canceled = not mcs.completed

print('cancelled =', canceled, '; nAtoms =', mcs.numAtoms, '; nBonds =',
      mcs.numBonds, '; SMARTS =', smarts)

p = rd.MolFromSmarts(smarts)
m1 = mol1.GetSubstructMatch(p, useChirality=False)
m2 = mol2.GetSubstructMatch(p, useChirality=False)
print 'match1:', m1
print 'match2:', m2
