#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <X11/Xlib.h>
#include <X11/Xft/Xft.h>

#define WIDTH 170
#define HEIGHT 170
#define X_OFFSET 10
#define Y_OFFSET 10
#define PLUS 2

Display *dpy;
Visual *Pvisual;
Colormap Pcmap;
unsigned int Pdepth;
Window  Root, win;
int screen, height, width;
Atom ATOM_WM_DELETE_WINDOW = None;

int str_len;
char *str = NULL;
char *fn_name = NULL;
char *bg_color_name = NULL;
char *fg_color_name = NULL;
XColor bg_color;

XftDraw *xftdraw;
XftFont *xftfont;
XftColor *xft_fg;

void CopyString(char **dest, const char *source);
XColor GetSimpleColor(char *name);


void Redraw(void)
{
	int i;

	XClearWindow(dpy, win);
	for(i=0; i<11; i++)
	{
		xft_fg->color.alpha = 0xffff * (100 - i*10) / 100;
		fprintf(stderr,"ALPHA: 0x%x\n", xft_fg->color.alpha);
#if 1
		XftDrawString8(xftdraw, xft_fg, xftfont,
			       X_OFFSET,
			       Y_OFFSET +
			       i*xftfont->height + xftfont->ascent,
			       (unsigned char *)str, str_len);
#else
		XftDrawRect(xftdraw, xft_fg, X_OFFSET,
			    Y_OFFSET + i*xftfont->height,
			    width - 2*Y_OFFSET, xftfont->height);
#endif
	}
}


void
Xloop(void)
{
	for(;;)
	{
		XEvent ev;
		XNextEvent(dpy,&ev);
		switch(ev.type)
		{
		case Expose:
			while (XCheckTypedWindowEvent(dpy, win, Expose, &ev));
			Redraw();
			break;
		case ClientMessage:
			if ((ev.xclient.format==32) &&
			    (ev.xclient.data.l[0]== ATOM_WM_DELETE_WINDOW))
				exit(0);
			break;
		default:
			break;
		}
	}
}

void initXft(void)
{
	xftdraw = XftDrawCreate(dpy, (Drawable) win, Pvisual, Pcmap);
	xftfont = XftFontOpenName (dpy, screen, fn_name);
	if (!xftfont)
	{
		fprintf(stderr,"fail to load font: %s\n", fn_name);
	}
	xft_fg = malloc(sizeof(XftColor));
	XftColorAllocName(dpy, Pvisual, Pcmap, fg_color_name, xft_fg);

	height = 2*Y_OFFSET + 11*xftfont->height; 
}

void CreateWindow(void)
{
	XSetWindowAttributes attr;

	width = WIDTH;
	height = HEIGHT;
	if (!(dpy = XOpenDisplay("")))
	{
		fprintf(stderr,"can't open display\n");
		exit (1);
	}

	screen = DefaultScreen(dpy);
	Root = RootWindow(dpy, screen);
	Pvisual = DefaultVisual(dpy, screen);
	Pdepth = DefaultDepth(dpy, screen);
	Pcmap = DefaultColormap(dpy, screen);

	if (bg_color_name != NULL)
		bg_color = GetSimpleColor(bg_color_name);
	else
		bg_color.pixel = BlackPixel(dpy, screen);;

	attr.background_pixel = bg_color.pixel;
	attr.background_pixmap = None;
	attr.border_pixel = 0;
	attr.colormap = Pcmap;

	win = XCreateWindow(dpy, Root, 0, 0, width, height, 0, Pdepth,
			    InputOutput, Pvisual,
			    CWBackPixel | CWBorderPixel | CWColormap,
			    &attr);

	XSelectInput(dpy, win, ExposureMask);

	ATOM_WM_DELETE_WINDOW = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
	{
		Atom proto[1];

		proto[0] = ATOM_WM_DELETE_WINDOW;
		XSetWMProtocols(dpy, win, proto, 1);
	}

	initXft();
	XResizeWindow(dpy, win, width, height);
	XMapWindow(dpy,win);
}


int
main(int argc, char **argv)
{
	int i;

	for(i=1;i<argc;i++)
	{
		if (strcasecmp(argv[i],"-str") == 0)
		{
			i++;
			CopyString(&str,argv[i]);
		}
		else if (strcasecmp(argv[i],"-fn") == 0)
		{
			i++;
			CopyString(&fn_name,argv[i]);
		}
		else if (strcasecmp(argv[i],"-bg") == 0)
		{
			i++;
			CopyString(&bg_color_name,argv[i]);
		}
		else if (strcasecmp(argv[i],"-fg") == 0)
		{
			i++;
			CopyString(&fg_color_name,argv[i]);
		}
	}


	if (str == NULL)
		CopyString(&str,"Hello World");

	if (fn_name == NULL)
		CopyString(&fn_name, "Luxi Mono");

	if (bg_color_name == NULL)
		CopyString(&bg_color_name,"White");

	if (fg_color_name == NULL)
		CopyString(&fg_color_name,"Black");

	str_len = strlen(str);

	CreateWindow();
	Xloop();
	return 0;
}


void CopyString(char **dest, const char *source)
{
	int len;
	const char *start;

	if (source == NULL) {
		*dest = NULL;
		return;
	}

	while ( isspace((unsigned char)*source) && (*source != '\n') )
		source++;
	start = source;

	len = 0;
	while ( (*source != '\n') && (*source != 0) ) {
		len++; source++;
	}
	source--;

	while( len > 0 && isspace((unsigned char)*source) ) {
		len--; source--;
	}

	*dest = malloc(len+1);
	strncpy(*dest,start,len);
	(*dest)[len]=0;
}

XColor GetSimpleColor(char *name)
{
	XColor color;

	memset(&color, 0, sizeof(color));
	if (!XParseColor (dpy, Pcmap, name, &color))
	{
		fprintf(stderr, "Cannot parse color \"%s\"\n",
			name ? name : "<blank>");
	}
	else if (!XAllocColor (dpy, Pcmap, &color))
	{
		fprintf(stderr, "Cannot allocate color \"%s\"\n", name);
	}
	return color;
}
