/*
 *  arch-tag: Header for the implementation of several functions to manage the covers
 *
 *  Copyright (C) 2004,2005 Marc Pavot <m.pavot@laposte.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


#ifndef __RB_COVER_H
#define __RB_COVER_H

#include <libgnomevfs/gnome-vfs.h>

#define TREE_COVER_SIZE 70

G_BEGIN_DECLS

typedef enum
{
	GET_FIRST_COVER,
	GET_ALL_COVERS
}RBCoverAmazonOperation;

typedef enum
{
	AMAZON_SMALL_COVER,
	AMAZON_MEDIUM_COVER,
	AMAZON_LARGE_COVER
}RBCoverAmazonCoversSize;

typedef enum
{
	SMALL_COVER,
	NORMAL_COVER
}RBCoverHomeCoversSize;

typedef enum
{
	OVERWRITE_MODE_ASK,
	OVERWRITE_MODE_REPLACE,
	OVERWRITE_MODE_SKIP
}RBCoverOverwriteMode;

typedef enum
{
	AMAZON_COVER,
	LOCAL_COVER
}RBCoverOrigin;

typedef void     (* RBCoverReadFileCallback) (GnomeVFSResult result,
					      GnomeVFSFileSize file_size,
					      char *file_contents,
					      gpointer callback_data);

typedef struct RBCoverReadFileHandle RBCoverReadFileHandle;


GnomeVFSResult 		rb_cover_load_local_cover 		(const char *location,
								 int *file_size,
								 char **file_contents);
GnomeVFSResult		rb_cover_load_amazon_covers 		(const char *artist,
								 const char *album,
								 GList **cover_uris,
								 GArray **file_size,
								 GList **file_contents,
								 RBCoverAmazonOperation operation,
								 RBCoverAmazonCoversSize cover_size);
GnomeVFSResult		rb_cover_save_cover			(const gchar *artist,
								 const gchar *album,
								 char *data,
								 int size,
								 RBCoverOrigin origin,
								 char *url,
								 RBCoverOverwriteMode overwrite_mode);
void	 		rb_cover_remove_cover			(const gchar *artist,
								 const gchar *album);
gboolean 		rb_cover_size_is_valid			(int size);

gboolean 		rb_cover_cover_exists			(const gchar *artist,
								 const gchar *album);
gchar*			rb_cover_make_cover_path 		(const gchar *artist,
								 const gchar *album,
								 RBCoverHomeCoversSize cover_size);
char*			rb_cover_make_amazon_xml_uri 		(const char *artist, 
					     			 const char *album);

GList*			rb_cover_parse_amazon_xml_file 		(char *xmldata,
								 int size,
								 RBCoverAmazonOperation operation,
								 RBCoverAmazonCoversSize cover_size);
gchar*			rb_cover_find_local_uri 		(const char *location);

RBCoverReadFileHandle* 	rb_cover_read_entire_file_async		(const char *uri,
								 int priority,
								 RBCoverReadFileCallback callback,
								 gpointer callback_data);
void			rb_cover_update_amazon_covers		(void);

gboolean		rb_cover_get_do_not_search		(const gchar *artist,
								 const gchar *album);
void			rb_cover_set_do_not_search		(const gchar *artist,
								 const gchar *album,
								 gboolean do_not_search);
G_END_DECLS

#endif /* __RB_COVER_H */
