/*
 *  arch-tag: Header for cover downloader
 *
 *  Copyright (C) 2004,2005 Marc Pavot <m.pavot@laposte.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "rhythmdb.h"
#include "rb-library-source.h"

#ifndef __RB_SHELL_COVERDOWNLOADER_H
#define __RB_SHELL_COVERDOWNLOADER_H

G_BEGIN_DECLS

#define RB_TYPE_SHELL_COVERDOWNLOADER         (rb_shell_coverdownloader_get_type ())
#define RB_SHELL_COVERDOWNLOADER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), RB_TYPE_SHELL_COVERDOWNLOADER, RBShellCoverdownloader))
#define RB_SHELL_COVERDOWNLOADER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), RB_TYPE_SHELL_COVERDOWNLOADER, RBShellCoverdownloaderClass))
#define RB_IS_SHELL_COVERDOWNLOADER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), RB_TYPE_SHELL_COVERDOWNLOADER))
#define RB_IS_SHELL_COVERDOWNLOADER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), RB_TYPE_SHELL_COVERDOWNLOADER))
#define RB_SHELL_COVERDOWNLOADER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), RB_TYPE_SHELL_COVERDOWNLOADER, RBShellCoverdownloaderClass))

typedef struct RBShellCoverdownloaderPrivate RBShellCoverdownloaderPrivate;

typedef struct
{
	GtkWindow parent;

	RBShellCoverdownloaderPrivate *priv;
} RBShellCoverdownloader;

typedef struct
{
	GtkWindowClass parent_class;
} RBShellCoverdownloaderClass;

typedef enum
{
	GET_LOCAL_COVERS,
	GET_AMAZON_COVERS,
	REMOVE_COVERS
} RBShellCoverdownloaderOperation;

GType      	rb_shell_coverdownloader_get_type 				(void);

GtkWidget * 	rb_shell_coverdownloader_new				(RhythmDB *db);

void 		rb_shell_coverdownloader_get_covers_from_genres 	(RBShellCoverdownloader *shell_coverdownloader,
									 RBLibrarySource *source,
									 GList *selected_genres,
									 RBShellCoverdownloaderOperation operation);
void 		rb_shell_coverdownloader_get_covers_from_artists 	(RBShellCoverdownloader *shell_coverdownloader,
									 RBLibrarySource *source,
									 GList *selected_artists,
									 RBShellCoverdownloaderOperation operation);
void 		rb_shell_coverdownloader_get_covers_from_albums 	(RBShellCoverdownloader *shell_coverdownloader,
									 RBLibrarySource *source,
									 GList *selected_artists_albums,
									 RBShellCoverdownloaderOperation operation);
void 		rb_shell_coverdownloader_get_single_cover 		(RBShellCoverdownloader *shell_coverdownloader,
									 RBLibrarySource *source,
									 const gchar *artist,
			        					 const gchar *album,
									 RBShellCoverdownloaderOperation operation);
void		rb_shell_coverdownloader_amazon_xml_loaded_cb		(GnomeVFSResult result,
									 GnomeVFSFileSize file_size,
									 char *file_contents,
									 gpointer callback_data);

void		rb_shell_coverdownloader_amazon_cover_loaded_cb 	(GnomeVFSResult result,
									 GnomeVFSFileSize file_size,
									 char *file_contents,
									 gpointer callback_data);

G_END_DECLS

#endif /* __RB_SHELL_COVERDOWNLOADER_H */
