#!/usr/bin/env ruby
require 'rock/bundle'
require 'readline'
require 'time'

ENV['BASE_LOG_LEVEL'] = 'DEBUG'
ENV['BASE_LOG_FORMAT'] = 'SHORT'

Rock::Bundles.initialize

Rock::Bundles.run 'aria::Task'=>'seekur_drv', 'camera_ids::Task'=>['camera1','camera2'] do

    Rock::Bundles.log_all

    aria = Rock::Bundles.get 'seekur_drv'
    camera1 = Rock::Bundles.name_service.get 'camera1'
    camera2 = Rock::Bundles.name_service.get 'camera2'

    aria.configure
    aria.start

    camera1.apply_conf_file("camera_ids::Task.yml", ["rgb_binning","cam1"])
    camera2.apply_conf_file("camera_ids::Task.yml", ["rgb_binning","cam2"])
    
    camera1.configure
    camera2.configure

    camera1.start
    camera2.start

    tstart = Time::now()

    Readline::readline("stop?")
    
    diff = Time::now() - tstart.to_i
    puts "Duration: #{diff.min} min, #{diff.sec} sec"
end
