/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file d_esp.h
 * @brief ROHC decompression context for the ESP profile.
 * @author Didier Barvaux <didier.barvaux@toulouse.viveris.com>
 * @author The hackers from ROHC for Linux
 * @author FWX <rohc_team@dialine.fr>
 */

#ifndef D_ESP_H
#define D_ESP_H

#include <netinet/ip.h>
#include <string.h>

#include "esp.h"
#include "d_generic.h"
#include "d_ip.h"


/**
 * @brief Define the ESP part of the decompression profile context.
 * 
 * This object must be used with the generic part of the decompression
 * context d_generic_context.
 *
 * @see d_generic_context
 */
struct d_esp_context
{
	/// the ESP sequence_number field
	u_int32_t	esp_sequence_number;
};


/*
 * Public function prototypes.
 */

void d_esp_destroy(void *context);

int d_esp_decode_ir(struct rohc_decomp *decomp,
                    struct d_context *context,
                    const unsigned char *rohc_packet,
                    const unsigned int rohc_length,
                    int large_cid_len,
                    int is_addcid_used,
                    unsigned char *dest);

unsigned int esp_detect_ir_size(struct d_context *context,
                                unsigned char *packet,
                                unsigned int plen,
                                unsigned int large_cid_len);

unsigned int esp_detect_ir_dyn_size(struct d_context *context,
                                    unsigned char *packet,
                                    unsigned int plen,
                                    unsigned int large_cid_len);

int esp_decode_static_esp(struct d_generic_context *context,
                          const unsigned char *packet,
                          unsigned int length,
                          unsigned char *dest);

int esp_decode_dynamic_esp(struct d_generic_context *context,
                           const unsigned char *packet,
                           unsigned int length,
                           unsigned char *dest);

int esp_get_static_size(void);

int esp_build_uncompressed_esp(struct d_generic_context *context,
                               struct d_generic_changes *active,
                               unsigned char *dest,
                               int payload_size);


#endif

