/*
 * Project: rtai_cpp - RTAI C++ Framework 
 *
 * File: $Id: $
 *
 * Copyright: (C) 2001 Erwin Rol <erwin@muffin.org>
 *
 * Licence:
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "rtai_wrapper.h"

#ifndef __COUNT_H__
#define __COUNT_H__

namespace RTAI {

class Count {
public:
	Count();
	Count(const Count& count);
	explicit Count(long long count);

	Count& operator=(const Count& count);
	Count& operator=(long long count);

	static Count now();
	static Count end();

	inline operator long long() const { return m_Count; }
	long long to_time() const;
	static Count from_time(long long time);

	bool operator==(const Count& count) const;
	bool operator==(long long count) const;

	inline bool operator!=(const Count& count) const { return !this->operator==(count); }
	inline bool operator!=(long long count) const { return !this->operator==(count); }

	bool operator<(const Count& count)const;
	bool operator>(const Count& count)const;

	bool operator<=(const Count& count)const;
	bool operator>=(const Count& count)const;

	Count& operator+=(const Count& count);
	Count& operator+=(long long count);

	Count& operator-=(const Count& count);
	Count& operator-=(long long count);
	
	Count  operator+(const Count& count) const;
	Count  operator+(long long count) const;

	Count  operator-(const Count& count) const;
	Count  operator-(long long count) const;
protected:
	long long m_Count; // internal count ticks
};

}; // namespace RTAI

#endif
