/*
 * Project: rtai_cpp - RTAI C++ Framework 
 *
 * File: $Id: $
 *
 * Copyright: (C) 2001 Erwin Rol <erwin@muffin.org>
 *
 * Licence:
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

static int errno;
#define __KERNEL_SYSCALLS__

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <asm/unistd.h>

#include "rt_mem_mgr.h"
 
extern int rt_printk(const char *format, ...);

#ifndef CTORS_SECTION_ASM_OP
#define CTORS_SECTION_ASM_OP    ".section\t.ctors,\"aw\""
#endif
#ifndef DTORS_SECTION_ASM_OP
#define DTORS_SECTION_ASM_OP    ".section\t.dtors,\"aw\""
#endif

/*  Declare a pointer to void function type.  */
typedef void (*func_ptr) (void);

#ifdef CRT_BEGIN

static func_ptr __DTOR_LIST__[];
static void
__do_global_dtors(void)
{
	static func_ptr *p = __DTOR_LIST__ + 1;
	static int completed = 0;

	rt_printk("GLOBAL DTORS START\n");	  

	while (*p)
	{
		p++;
		(*(p-1)) ();
	}

	rt_printk("GLOBAL DTORS END\n");	  
	
	completed = 1;
}

static func_ptr __CTOR_END__[];
static void
__do_global_ctors(void)
{
	func_ptr *p;

	rt_printk("GLOBAL CTORS START\n");	  

	for (p = __CTOR_END__ - 1; *p != (func_ptr) -1; p--){
		(*p) ();
	}

	rt_printk("GLOBAL CTORS END\n");	  
}

#ifdef USE_MAIN

extern int main(int argc, char* argv[]);

static int main_thread(void *unused){
	sigset_t tmpsig;

	sprintf(current->comm,"main");
	daemonize();

	/* Block all signals except SIGKILL and SIGSTOP */
	spin_lock_irq(&current->sigmask_lock);
	tmpsig = current->blocked;
	siginitsetinv(&current->blocked, sigmask(SIGKILL) | sigmask(SIGSTOP) );
	recalc_sigpending(current);
	spin_unlock_irq(&current->sigmask_lock);

	return 	main(0,0);
}

#endif // USE_MAIN

// RTAI-- MODULE INIT and CLEANUP functions

int __init startup_init(void){
	__do_global_ctors();

#ifdef USE_MAIN
	kernel_thread(main_thread, NULL , CLONE_FS | CLONE_FILES | CLONE_SIGHAND);
#endif

	return 0;
}

void startup_cleanup(void)
{
#ifdef USE_MAIN
	int waitpid_result = 1;
	
	while( waitpid_result > 0 )
		waitpid_result = waitpid(-1,NULL,__WCLONE|WNOHANG);
#endif
	__do_global_dtors();
}

module_init(startup_init)
module_exit(startup_cleanup)

/* Force cc1 to switch to .data section.  */
static func_ptr force_to_data[0] __attribute__ ((__unused__)) = { };

asm (CTORS_SECTION_ASM_OP);     /* cc1 doesn't know that we are switching! */
static func_ptr __CTOR_LIST__[1] __attribute__ ((__unused__))
  = { (func_ptr) (-1) };

asm (DTORS_SECTION_ASM_OP);     /* cc1 doesn't know that we are switching! */
static func_ptr __DTOR_LIST__[1] __attribute__ ((__unused__)) 
  = { (func_ptr) (-1) };
 
#else // CRT_BEGIN
  
/* Force cc1 to switch to .data section.  */
static func_ptr force_to_data[0] __attribute__ ((__unused__)) = { };

asm (CTORS_SECTION_ASM_OP);     /* cc1 doesn't know that we are switching! */
static func_ptr __CTOR_END__[1] __attribute__ ((__unused__)) 
  = { (func_ptr) 0 };

asm (DTORS_SECTION_ASM_OP);     /* cc1 doesn't know that we are switching! */
static func_ptr __DTOR_END__[1] __attribute__ ((__unused__))
  = { (func_ptr) 0 };

#endif // CRT_BEGIN
