#include <stdio.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include <rtai_fifos.h>

static int end;

static void endme(int dummy) { end = 1;}

int main()
{
	int fd0;
	struct sample { long min; long max; int index; } samp;
	
	signal(SIGINT, endme);

	if ((fd0 = open("/dev/rtf0", O_RDONLY)) < 0) {
		fprintf(stderr, "Error opening /dev/rtf0\n");
		exit(1);
	}


	while (!end) {
		read(fd0, &samp, sizeof(samp));
		printf("*** min: %8ld, max: %8ld average: %d ***\n", samp.min, samp.max, samp.index);
		fflush(stdout);
	}

	return 0;
}
