/*
COPYRIGHT (C) 2000  Paolo Mantegazza (mantegazza@aero.polimi.it)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
*/


#include <stdio.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <sys/ioctl.h>


#include <task.h>

static int end;

void endme(int dummy)
{
	end = 1;
}

int main(void)
{
	fd_set input;
	struct timeval tv;
	unsigned int msg, ch;
	RTAI::Task *task;
	RTAI::Mailbox* mbx;
	struct sample { long long min; long long max; int index; } samp;

	signal(SIGINT, endme);
	tv.tv_sec = 0;
	tv.tv_usec = 20000;

	if(!(task = new RTAI::Task("LATCHK",1,0,0))){
		printf("CANNOT INIT MASTER TASK\n");
		exit(1);
	}

 	if (!(mbx = new RTAI::Mailbox("LATMBX")))) {
		printf("CANNOT FIND MAILBOX\n");
		exit(1);
	}

	while (!end) {
		mbx->receive(&samp, sizeof(samp));
		printf("*** min: %d, max: %d average: %d (ent ends check, a/ent or ^C both) ***\n", (int) samp.min, (int) samp.max, samp.index);
		FD_ZERO(&input);
		FD_SET(0, &input);
	        if (select(1, &input, NULL, NULL, &tv)) {
			ch = getchar();
			break;
		}
	}

	if (ch == 'a' || end) {
		RTAI::Task tmp_task("LATCAL");
		tmp.rpc(msg, &msg);
	}

	delete task;

	exit(0);
}
