/*
COPYRIGHT (C) 2000  Paolo Mantegazza (mantegazza@aero.polimi.it)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
*/


#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sched.h>
#include <sys/mman.h>

#include <task_proxy.h>
#include <mbx.h>

//#define OVERALL

#define SKIP 4000

#define PERIOD 100000

int main(int argc)
{
	int diff;
	int skip;
	int average;
	int min_diff;
	int max_diff;
	int period;
	RTAI::Time expected;
	RTAI::Mailbox *mbx;
	RTAI::Task *task;
	struct sample { long long min; long long max; int index; } samp;

	mlockall(MCL_CURRENT | MCL_FUTURE);

 	if (!(mbx = new RTAI::Mailbox("LATMBX", 20*sizeof(samp)))) {
		printf("CANNOT CREATE MAILBOX\n");
		exit(1);
	}

 	if (!(task = new RTAI::Task("LATCAL", 0, 0, 0, SCHED_FIFO, 1))) {
		printf("CANNOT INIT MASTER TASK\n");
		exit(1);
	}

	if (argc == 1) {
		RTAI::set_oneshot_mode();
		RTAI::start_timer(0);
	}

	task->make_hard_real_time();
	period = nano2count(PERIOD);
	task->make_periodic(expected = rt_get_time()+5*period, period);

#ifdef OVERALL
	min_diff = 1000000000;
	max_diff = -1000000000;
#endif
	while (1) {
#ifndef OVERALL
		min_diff = 1000000000;
		max_diff = -1000000000;
#endif
		average = 0;

		for (skip = 0; skip < SKIP; skip++) {
			expected += period;
			task->wait_period();

			diff = (int)count2nano(rt_get_time() - expected);
			if (diff < min_diff) {
				min_diff = diff;
			}
			if (diff > max_diff) {
				max_diff = diff;
			}
			average += diff;
		}
		samp.min = min_diff;
		samp.max = max_diff;
		samp.index = average/SKIP;
		mbx->send_if(&samp, sizeof(samp));
		{
			RTAI::TaskProxy tp("LATCHK");
			if( tp.receive_if((unsigned int *)&average)) {
				tp.return((unsigned int)average);
				break;
			}
		}
	}

	while( rt_get_adr(nam2num("LATCHK"))) {
		RTAI::Task::sleep(nano2count(1000000));
	}
	task->make_soft_real_time();
	delete task;
	delete mbx;
	if (argc == 1) {
		RTAI::stop_timer();	
	}
}
