/*
COPYRIGHT (C) 1999  Paolo Mantegazza (mantegazza@aero.polimi.it)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
*/

#include "test.h"

static int cpu_used[ RTAI_NR_CPUS ];
static unsigned long long name[2] = { 0xaaaaaaaaaaaaaaaaLL, 0xbbbbbbbbbbbbbbbbLL };

static Module theModule;

MTask::MTask(int t)
: RTAI::Task(STACK_SIZE,0,0,0,0) 
{
	m_T = t;
}
	
int MTask::run(){
	unsigned long long msg;
	int size;

	while (1) {
		CHECK_FLAGS;
		cpu_used[ RTAI::hard_cpu_id() ]++;

		if ( (size = theModule.smbx.send_timed(&name[m_T],RTAI::Count::from_time(TIMEOUT)) ) ) {
			__rt_printk("SEND TIMEDOUT %d %d\n", m_T, size);
			goto prem;
		}

		msg = 0;
		if ((size = theModule.rmbx[m_T].receive_timed(&msg,RTAI::Count::from_time(TIMEOUT)))) {
			__rt_printk("RECEIVE TIMEDOUT %d %d %x %x<\n", m_T, size, ((int *)&msg)[0], ((int *)&msg)[1]);
			goto prem;
		}

		if (msg != 0xccccccccccccccccLL) {
			__rt_printk("WRONG REPLY %d %x %x<\n", m_T, ((int *)&msg)[0], ((int *)&msg)[1]);
			goto prem;
		}
			
		sleep(RTAI::Count::from_time(SLEEP_TIME));
	}
prem: 
	__rt_printk("TASK # %d ENDS PREMATURELY\n", m_T);

	return -1;
}


BTask::BTask(int t)
: RTAI::Task(STACK_SIZE,0,0,0,0) 
{
	m_T = t;
}

int BTask::run()
{
	unsigned long long msg;
	unsigned long long name = 0xccccccccccccccccLL;

	while (1) {
		CHECK_FLAGS;
		cpu_used[ RTAI::hard_cpu_id() ]++;

		theModule.smbx.receive(&msg);
		if (msg == 0xaaaaaaaaaaaaaaaaLL) {
			m_T = 0;
		} else {
			if (msg == 0xbbbbbbbbbbbbbbbbLL) {
				m_T = 1;
			} else {
				__rt_printk("SERVER RECEIVED AN UNKNOWN MSG %x %x<\n", ((int *)&msg)[0], ((int *)&msg)[1]);
				m_T = 0;
				goto prem;
			}
		}
		theModule.rmbx[m_T].send(&name);
	}
prem:
	__rt_printk("SERVER TASK ENDS PREMATURELY\n");

	return -1;
}


Module::Module(){
	smbx.init(5);
	rmbx[0].init(1);
	rmbx[1].init(3);

	m_BTask = new BTask(0);
	m_MTask[0] = new MTask(0);
	m_MTask[1] = new MTask(1);

	RTAI::set_oneshot_mode();
	RTAI::start_timer( RTAI::Count::from_time(SLEEP_TIME) );
	m_BTask->resume();
	m_MTask[0]->resume();
	m_MTask[1]->resume();
}

Module::~Module(){
	int cpuid;

	RTAI::stop_timer();


	__rt_printk("\n\nCPU USE SUMMARY\n");
	for (cpuid = 0; cpuid < RTAI_NR_CPUS; cpuid++) {
		__rt_printk("# %d -> %d\n", cpuid, cpu_used[cpuid]);
	}
	__rt_printk("END OF CPU USE SUMMARY\n\n");

	delete m_MTask[1];
	delete m_MTask[0];
	delete m_BTask;
}

