#include <task.h>
#include <sem.h>

class A : public RTAI::Task {
public:
	A(){ __rt_printk("A()\n"); }
	virtual ~A(){ __rt_printk("~A()\n"); }

	virtual void hello(){ __rt_printk("A::hello()\n"); }

	virtual int run(){ return __rt_printk("A::run()\n"); }
};

class B : public A {
public:
	B(){ __rt_printk("B()\n"); }
	virtual ~B(){ __rt_printk("~B()\n"); }

	virtual void hello(){ __rt_printk("B::hello()\n"); }

	virtual int run(){ return __rt_printk("B::run()\n"); }
};


class C {
public:
	C(){ __rt_printk("C()\n"); }
	~C(){ __rt_printk("~C()\n"); }
};

class D {
public:
	D(){ __rt_printk("D()\n"); }
	~D(){ __rt_printk("~D()\n"); }
protected:
	static C m_c;
};


C D::m_c;

A g_a;
B g_b;

RTAI::BinarySemaphore g_Lock;

int main(int argc, char* argv[]){
	__rt_printk("main begin \n");

	A l_a;
	B l_b;

	A* p_a;

	p_a = new B;

	g_a.init(0,0,0,0,0);
	g_b.init(0,0,0,0,0);
	l_a.init(0,0,0,0,0);
	l_b.init(0,0,0,0,0);
	p_a->init(0,0,0,0,0);
	__rt_printk("init done\n");	

	g_a.resume();
	g_b.resume();
	l_a.resume();
	l_b.resume();
	p_a->resume();
	__rt_printk("resume done!\n");	

	g_a.hello();
	g_b.hello();
	l_a.hello();
	l_b.hello();
	p_a->hello();
	
	__rt_printk("hello done\n");

	delete p_a;

	__rt_printk("main end \n");

	return 0;
}
