/*
 * Project: rtai_cpp - RTAI C++ Framework 
 *
 * File: $Id: $
 *
 * Copyright: (C) 2001 Erwin Rol <erwin@muffin.org>
 *
 * Licence:
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <asm/unistd.h>

#include "rt_mem_mgr.h"
#include "rtai_wrapper.h"

// RTAI-- MODULE INIT and CLEANUP functions

int __init rtai_cpp_init(void){

	cpp_key = __rt_tld_create_key();
	
	if(cpp_key == -1){
		__rt_printk("Could not get free TLD key\n");
		return -1;
	}
	
	__rt_printk("Got %d TLD key\n",cpp_key);
	
	return 0;
}

void rtai_cpp_cleanup(void)
{
	if(cpp_key != -1)
		__rt_tld_free_key(cpp_key);
}

module_init(rtai_cpp_init)
module_exit(rtai_cpp_cleanup)
  
