/*
 * Project: rtai_cpp - RTAI C++ Framework 
 *
 * File: $Id: $
 *
 * Copyright: (C) 2001 Erwin Rol <erwin@muffin.org>
 *
 * Licence:
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "linux_wrapper.h"

#ifndef __RTAI_WRAPPER_H__
#define __RTAI_WRAPPER_H__

#ifdef __cplusplus
extern "C"  {
#endif

#include <rtai_types.h>

// in LXRT a RT_TASK is a void
// while in RTAI it is the real structure
// we use a define that we undef in 
// rtai_wrapper.c so it won't colide with
// the typedef. Yes! this all is very ugly
// but untill a total cleanup of all the
// include files it is the best way to do it
#ifdef __KERNEL__
#define RT_TASK struct rt_task_struct
#define SEM struct rt_semaphore
#define MBX struct rt_mailbox
#else
#define RT_TASK struct rt_task_struct
#define SEM void*
#define MBX void*
#endif
#define CND SEM


extern int __rt_printk(const char *format, ... );

extern int cpp_key;       

#define RTAI_NR_CPUS 1

extern void __rt_get_global_lock(void);
extern void __rt_release_global_lock(void);
extern int __hard_cpu_id(void);
extern int __rt_assign_irq_to_cpu(int irq, unsigned long cpus_mask);
extern int __rt_reset_irq_to_sym_mode(int irq);


extern long long __nano2count(long long nano);
extern long long __count2nano(long long count);
extern unsigned long __nam2num(const char *name);
extern void __num2nam(unsigned long num, char *name);


extern long long __rt_get_time(void); 
extern long long __rt_get_time_ns(void); 
extern long long __rt_get_cpu_time_ns(void);
extern void __rt_set_oneshot_mode(void);
extern void __rt_set_periodic_mode(void);
extern long long __start_rt_timer(int period);
extern void __stop_rt_timer(void);


#ifdef __KERNEL__

extern RT_TASK*  __rt_task_init(void (*rt_thread)(int), int data,
			int stack_size, int priority, int uses_fpu, void(*signal)(void));

extern RT_TASK*  __rt_task_init_cpuid(void (*rt_thread)(int), int data,
				int stack_size, int priority, int uses_fpu,
				void(*signal)(void), unsigned int run_on_cpu);
#else
extern RT_TASK* __rt_task_init_schmod(int name, int priority, int stack_size, 
				int max_msg_size, int policy, int cpus_allowed);


extern unsigned long __rt_get_name(void *adr);
extern void *__rt_get_adr(int name);

#endif



extern void __rt_set_runnable_on_cpus(RT_TASK *task, unsigned int cpu_mask);
extern void __rt_set_runnable_on_cpuid(RT_TASK *task, unsigned int cpuid);
extern int __rt_task_delete(RT_TASK *task);
extern RT_TASK* __rt_whoami(void);
extern void __rt_task_yield(void);
extern int __rt_task_suspend(RT_TASK* task);
extern int __rt_task_resume(RT_TASK* task);

extern int __rt_tld_create_key(void);
extern int __rt_tld_free_key(int key);
extern int __rt_tld_set_data(RT_TASK *task,int key,void* data);
extern void* __rt_tld_get_data(RT_TASK *task,int key);

extern int __rt_task_make_periodic(RT_TASK* task, long long start_time, long long period);
extern int __rt_task_make_periodic_relative_ns(RT_TASK* task, long long start_delay, long long period);
extern void __rt_task_wait_period(void);
extern void __rt_busy_sleep(int nanosecs);
extern void __rt_sleep(long long delay);
extern void __rt_sleep_until(long long time);
extern void __rt_task_signal_handler(RT_TASK* task, void (*handler)(void));
extern int __rt_task_use_fpu(RT_TASK* task, int use_fpu_flag);
extern void __rt_linux_use_fpu(int use_fpu_flag);
extern void __rt_preempt_always(int yes_no);
extern void __rt_preempt_always_cpuid(int yes_no, unsigned int cpu_id);
extern void __rt_make_soft_real_time(void);
extern void __rt_make_hard_real_time(void);
extern int long __rt_is_hard_real_time(RT_TASK *rt_task);
extern int long __rt_is_soft_real_time(RT_TASK *rt_task);

/* semaphore wrappers */

#define __BIN_SEM	BIN_SEM
#define __CNT_SEM	CNT_SEM
#define __RES_SEM	RES_SEM

extern SEM* __rt_typed_sem_init(int value, int type);
extern int __rt_sem_delete(SEM* sem);
extern int __rt_sem_signal(SEM* sem);
extern int __rt_sem_broadcast(SEM* sem);
extern int __rt_sem_wait(SEM* sem);
extern int __rt_sem_wait_if(SEM* sem);
extern int __rt_sem_wait_until(SEM* sem, long long time);
extern int __rt_sem_wait_timed(SEM* sem, long long delay);

/* mailbox wrappers */

extern MBX* __rt_mbx_init(int size);
extern int __rt_mbx_delete(MBX* mbx);
extern int __rt_mbx_send(MBX* mbx, void* msg, int msg_size);
extern int __rt_mbx_send_wp(MBX* mbx, void* msg, int msg_size);
extern int __rt_mbx_send_if(MBX* mbx, void* msg, int msg_size);
extern int __rt_mbx_send_until(MBX* mbx, void* msg, int msg_size, long long time);
extern int __rt_mbx_send_timed(MBX* mbx, void* msg, int msg_size, long long delay);
extern int __rt_mbx_receive(MBX* mbx, void* msg, int msg_size);
extern int __rt_mbx_receive_wp(MBX* mbx, void* msg, int msg_size);
extern int __rt_mbx_receive_if(MBX* mbx, void* msg, int msg_size);
extern int __rt_mbx_receive_until(MBX* mbx, void* msg, int msg_size, long long time);
extern int __rt_mbx_receive_timed(MBX* mbx, void* msg, int msg_size, long long delay);


// rtf functions

#define __MAX_FIFOS 64

extern int __rtf_create(unsigned int fifo, int size);
extern int __rtf_destroy(unsigned int fifo);
extern int __rtf_reset(unsigned int fifo);
extern int __rtf_resize(unsigned int fifo, int size);
extern int __rtf_put(unsigned int fifo, void *buf, int count);
extern int __rtf_get(unsigned int fifo, void *buf, int count);
extern int __rtf_create_handler(unsigned int fifo, int (*handler)(unsigned int fifo));

#ifdef __cplusplus
}
#endif

#endif

