/*
 * Project: rtai_cpp - RTAI C++ Framework 
 *
 * File: $Id: $
 *
 * Copyright: (C) 2001 Erwin Rol <erwin@muffin.org>
 *
 * Licence:
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "sem.h"

namespace RTAI {

Semaphore::Semaphore(int value, int type){
	m_Sem = __rt_typed_sem_init(value,type);
}

Semaphore::~Semaphore(){
	if(m_Sem != 0)
		__rt_sem_delete(m_Sem);
}

int Semaphore::signal(){
	return __rt_sem_signal(m_Sem);
}

int Semaphore::broadcast(){
	return __rt_sem_broadcast(m_Sem);
}

int Semaphore::wait(){
	return __rt_sem_wait(m_Sem);
}

int Semaphore::wait_if(){
	return __rt_sem_wait_if(m_Sem);
}

int Semaphore::wait_until(const Time& time){
	return __rt_sem_wait_until(m_Sem,time.to_count());
}

int Semaphore::wait_timed(const Time& delay){
	return __rt_sem_wait_timed(m_Sem,delay.to_count());
}

BinarySemaphore::BinarySemaphore()
:	Semaphore(0,__BIN_SEM)
{
}

BinarySemaphore::~BinarySemaphore(){
}
  
CountingSemaphore::CountingSemaphore()
:	Semaphore(0,__CNT_SEM)
{
}

CountingSemaphore::~CountingSemaphore(){
}

ResourceSemaphore::ResourceSemaphore()
:	Semaphore(0,__RES_SEM)
{
}

ResourceSemaphore::~ResourceSemaphore(){
}

};