/*
 * Project: rtai_cpp - RTAI C++ Framework 
 *
 * File: $Id: $
 *
 * Copyright: (C) 2001 Erwin Rol <erwin@muffin.org>
 *
 * Licence:
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "rtai_wrapper.h"

#ifndef __TIME_H__
#define __TIME_H__

namespace RTAI {

class Time {
public:
	Time();
	Time(const Time& time);
	explicit Time(long long time);

	Time& operator=(const Time& time);
	Time& operator=(long long time);

	static Time now();
	static Time end();

	inline operator long long() const { return m_Time; }
	long long to_count() const;
	static Time from_count(long long count);

	bool operator==(const Time& time) const;
	bool operator==(long long time) const;

	inline bool operator!=(const Time& time) const { return !this->operator==(time); }
	inline bool operator!=(long long time) const { return !this->operator==(time); }

	bool operator<(const Time& time)const;
	bool operator>(const Time& time)const;

	bool operator<=(const Time& time)const;
	bool operator>=(const Time& time)const;

	Time& operator+=(const Time& time);
	Time& operator+=(long long time);

	Time& operator-=(const Time& time);
	Time& operator-=(long long time);
	
	Time  operator+(const Time& time) const;
	Time  operator+(long long time) const;

	Time  operator-(const Time& time) const;
	Time  operator-(long long time) const;
protected:
	long long m_Time; // nanosecs
};

}; // namespace RTAI

#endif