/***************************************************************************
 *   Copyright (C) 2006 by Jorge Almeida   *
 *   j-almeida@criticalsoftware.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <arpa/inet.h>
#include <linux/if.h>
#include <linux/if_ether.h>
#include <linux/if_packet.h>
#include <linux/net.h>

#include <rtnet.h>
#include <rtai_lxrt.h>
#include <rtdm/rtdm.h>


///protocol type
#define PROTOCOL    0x1234
///RTAI stack size
#define DEFAULT_STACK_SIZE          64*1024
///RTAI message size
#define DEFAULT_MESSAGE_SIZE     256
///RTAI thread stack size
#define THREAD_STACK_SIZE           DEFAULT_STACK_SIZE
///RTAI priority for the feeders
#define PRIORIDADE_FEEDER           98
///RTAI priority for the managers
#define PRIORIDADE_MANAGERS      90

const char* g_pchDestMacAddress = "00:00:00:00:00:11";

int rt_eth_aton(unsigned char *addr_buf, const char *mac);
int hex2int(unsigned char hex_char);

int main(int argc, char *argv[])
{
    int nReturn = 0;
    int m_nFileDescriptor = -1;
    RT_TASK *psMainTask;
    const char puchData[1500];
    int nCounter = 0;
    struct sockaddr_ll sFrom = {0};
    socklen_t from_len = sizeof(struct sockaddr_ll);


    //RT task initialization
    if (!(psMainTask = rt_task_init(nam2num("TASK2"), PRIORIDADE_FEEDER, DEFAULT_STACK_SIZE, DEFAULT_MESSAGE_SIZE)) ) {
        printf("CANNOT INIT MASTER TASK!! Value: %d\n", psMainTask);
       return -1;
    }
    rt_task_use_fpu(psMainTask, 1);
    mlockall( MCL_CURRENT | MCL_FUTURE );


    nReturn = rt_dev_socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
    if( nReturn >= 0 )
    {
        m_nFileDescriptor = nReturn;
    }
        else
    {
        printf( "Error opening rt socket. Error = %d\n",nReturn);
        return -1;
    }

    rt_make_hard_real_time();


    while (nCounter < 16)
    {
        printf(" Waiting for Ethernet Message\n");
        nReturn = rt_dev_recvfrom(  m_nFileDescriptor,
                                                    (void*)puchData,
                                                    1500,
                                                    0,
                                                    (struct sockaddr *) &sFrom ,
                                                    &from_len);
        if(nReturn < 0)
        {
            printf( "Error receiving message. Error = %d\n",nReturn);
        }
        else
        {
            printf(" Message received sucessfully. Bytes received = %d\n",nReturn);
            printf("received packet from %02X:%02X:%02X:%02X:%02X:%02X, "
            "length: %d,\ncontent: ",
            sFrom.sll_addr[0], sFrom.sll_addr[1], sFrom.sll_addr[2],
            sFrom.sll_addr[3], sFrom.sll_addr[4], sFrom.sll_addr[5],
            nReturn);
            int nI = 0;
            for(nI = 0 ; nI < nReturn  ; nI++ )
                printf(" %02X ",puchData[nI]);
            printf("\n");

            }

        nCounter++;
    }

    rt_make_soft_real_time();

    if(m_nFileDescriptor >= 0)
    {
        nReturn = rt_dev_close(m_nFileDescriptor);
        if( nReturn < 0)
        {
            printf( "Error closing rt socket. Error = %d\n",nReturn);
        }
    }

    //RT task deleting
    rt_task_delete( psMainTask );

    return EXIT_SUCCESS;
}


int hex2int(unsigned char hex_char)
{
    if ((hex_char >= '0') && (hex_char <= '9'))
        return hex_char - '0';
    else if ((hex_char >= 'a') && (hex_char <= 'f'))
        return hex_char - 'a' + 10;
    else if ((hex_char >= 'A') && (hex_char <= 'F'))
        return hex_char - 'A' + 10;
    else
        return -EINVAL;
}



int rt_eth_aton(unsigned char *addr_buf, const char *mac)
{
    int i = 0;
    int nibble;


    while (1) {
        if (*mac == 0)
            return -EINVAL;

        if ((nibble = hex2int(*mac++)) < 0)
            return nibble;
        *addr_buf = nibble << 4;

        if (*mac == 0)
            return -EINVAL;

        if ((nibble = hex2int(*mac++)) < 0)
            return nibble;
        *addr_buf++ |= nibble;

        if (++i == 6)
            break;

        if ((*mac == 0) || (*mac++ != ':'))
            return -EINVAL;

    }
    return 0;
}



