#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/socket.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/proc_fs.h>
#include <linux/ioport.h>
#include <linux/net.h>

#include <rtai.h>
#include <rtai_lxrt.h>
#include <rtai_mbx.h>
#include <rtai_msg.h>
#include <rtai_fifos.h>
#include <rtai_sem.h>
#include <rtai_registry.h>
#include <rtnet.h>


MODULE_LICENSE("GPL");

/* Sequence:
 *
 * Client      Server
 *    -- 1472 -->
 *    --   32 -->
 *    <-- 800 ---
 * */


static int sock = -1;

static char *local_ip_addr = "192.168.8.3";
static char *server_ip_addr = "192.168.8.2";

static RT_TASK client_task;

static short udp_port = 22222;

static long long timeout_ns = 1000000000LL;  // 1s timeout

#define SENDDATASIZE 1472
static char data[SENDDATASIZE];

/**
 * The data process handles the realtime data from the rtos_comm module.
 * Once initialized, the data process does the job...
 * */
static void *client_process(void *arg)
{
    int loop = 0;
    rt_printk("client_process started\n");
    while (1)
    {
        int rc;
        int n_rec;

        strcpy(data, "long");
        rc = rt_dev_send(sock, data, SENDDATASIZE, 0);

        if (rc < 0)
        {
            rt_printk("Error sending long message: %i\n", rc);
        }

        strcpy(data, "short");
        rc = rt_dev_send(sock, data, 32, 0);
        if (rc < 0)
        {
            rt_printk("Error sending short message: %i\n", rc);
        }

        

        n_rec = rt_dev_recv(sock, data, SENDDATASIZE, 0);

        if (n_rec > 0)
        {
             // rt_printk("received %i\n", n_rec);

        }
        else
        {
            rt_printk("Timeout n_rec:%i\n", n_rec);
            rt_sleep(100000);
        }

        if (++loop % 100000 == 0)
        {
            rt_printk("Loop %u\n", loop);
        }
    }
            
        
}




/* *****************************************************************
 * ***************************************************************** */
int init_module(void)
{
    int rc;


    /* create rt-socket */
    sock=rt_dev_socket(AF_INET,SOCK_DGRAM,0);
    if (sock < 0)
    {
        rt_printk("Error creating rt_socket: %i\n", sock);
        goto ERROR_OUT;
    }

    rt_dev_ioctl(sock, RTNET_RTIOC_TIMEOUT, &timeout_ns);

    /* bind socket to local_addr */
    {
        unsigned long local_ip  = rt_inet_aton(local_ip_addr);
        struct sockaddr_in sockaddr;
        memset(&sockaddr, 0, sizeof(struct sockaddr_in));
        sockaddr.sin_family = AF_INET;
        sockaddr.sin_port = htons(udp_port);
        sockaddr.sin_addr.s_addr = local_ip;
        rc = rt_dev_bind(sock, (struct sockaddr *) &sockaddr, sizeof(struct sockaddr_in));
        if (rc)
        {
            rt_printk("rt_dev_bind: rc=%i\n", rc);
            goto ERROR_OUT;
        }
    }

    /* Connect to server */
    {
        unsigned long server_ip  = rt_inet_aton(server_ip_addr);
        struct sockaddr_in sockaddr;
        memset(&sockaddr, 0, sizeof(struct sockaddr_in));
        sockaddr.sin_family = AF_INET;
        sockaddr.sin_port = htons(udp_port);
        sockaddr.sin_addr.s_addr = server_ip;
        rc = rt_dev_connect(sock, (struct sockaddr *) &sockaddr, sizeof(struct sockaddr_in));
        if (rc)
        {
            rt_printk("rt_dev_connect: rc=%i\n", rc);
            goto ERROR_OUT;
        }
    }


    rt_set_oneshot_mode();
    start_rt_timer(0);
    
    rc = rt_task_init_cpuid(&client_task,(void *)client_process,0,4096,2,0,NULL, 0);
    if (rc)
    {
        rt_printk("Error: rt_task_init for data_process failed \n");
        goto ERROR_OUT;
    }

    

    rt_task_resume(&client_task);
    return 0;

ERROR_OUT:
    rt_printk("Error out\n");
    return 1;
}


void cleanup_module(void)
{
    if (sock >= 0)
    {
        rt_dev_close(sock);
    }
    rt_task_suspend(&client_task);
    rt_task_delete(&client_task);

    rt_printk ("cleanup_module done\n");
}


