#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>
#include <arpa/inet.h>
#include <linux/if.h>
#include <linux/if_ether.h>
#include <linux/if_packet.h>
#include <linux/net.h>

#include <native/task.h>
#include <rtnet.h>


/* Sequence:
 *
 * Clientr     Server
 *    -- 1472 -->
 *    --   32 -->
 *    <-- 800 ---
 * */


static int sock = -1;

static char *local_ip_addr = "192.168.8.2";

static RT_TASK server_task;

static short udp_port = 22222;

static long long timeout_ns = 1000000000LL;  // 1s timeout

#define RECVDATASIZE 1472
#define ACKNOWLEDGESIZE 800
static char recvdata[RECVDATASIZE];

/**
 * The data process handles the realtime data from the rtos_comm module.
 * Once initialized, the data process does the job...
 * */
static void server_process(void *arg)
{
    int data_received = 0;
    unsigned int loop = 0;
    struct sockaddr_in sockaddr_client;
    printf("server_process started\n");
    while (1)
    {
        int n_rec;
        socklen_t sockaddr_len = sizeof(sockaddr_client);

        /* Sequence: First receive a large message */

        n_rec = rt_dev_recvfrom(sock, recvdata, RECVDATASIZE, 0, 
                                (struct sockaddr*) &sockaddr_client, &sockaddr_len);

        if (n_rec > 0)
        {
            int rc;
            long long short_timeout_ns = 1000000; // 1ms

            data_received = 1;

            rt_dev_ioctl(sock, RTNET_RTIOC_TIMEOUT, &short_timeout_ns);

            if (n_rec < 100)
            {
                // This was the short message!
                // Read again to have the large message.
                printf("Received the short message instead of the long message\n");
                n_rec = rt_dev_recv(sock, recvdata, RECVDATASIZE + 20, 0);
                if (n_rec < 0)
                {
                    printf("The re-recv failed: %i\n", n_rec);
                }


            }

            n_rec = rt_dev_recv(sock, recvdata, RECVDATASIZE, 0);

            if (n_rec > 0)
            {
                if (n_rec > 100)
                {
                    printf("Instead of the short a long message %i has been received\n", n_rec);
                }
            }
            else
            {
                printf("error receiving the second message:%i\n", n_rec);
            }


            // Reactivate the original timeout
            rt_dev_ioctl(sock, RTNET_RTIOC_TIMEOUT, &timeout_ns);

            // Send an acknowledge:
            //
            rc = rt_dev_sendto(sock, recvdata, ACKNOWLEDGESIZE, 0, 
                                (struct sockaddr *)&sockaddr_client, sockaddr_len);
            if (rc < 0)
            {
                printf("Error rt_dev_send: %i\n", rc);
            }

        }
        else
        {
            if (data_received)
                printf("Timeout n_rec:%i\n", n_rec);
            rt_task_sleep(100000);
        }

        /* Alive printout: */
        if (++loop % 100000 == 0)
        {
            printf("Loop %u\n", loop);
        }
    }
}


void catch_signal(int sig)
{
    if (sock >= 0)
    {
        rt_dev_close(sock);
    }

    printf("catch_signal done\n");
}


/* *****************************************************************
 * ***************************************************************** */
int main()
{
    int rc;


    signal(SIGTERM, catch_signal);
    signal(SIGINT, catch_signal);
    signal(SIGHUP, catch_signal);
    mlockall(MCL_CURRENT|MCL_FUTURE);

    /* create rt-socket */
    sock=rt_dev_socket(AF_INET,SOCK_DGRAM,0);
    if (sock < 0)
    {
        printf("Error creating rt_socket: %i\n", sock);
        goto ERROR_OUT;
    }

    rt_dev_ioctl(sock, RTNET_RTIOC_TIMEOUT, &timeout_ns);

    /* bind socket to local_addr */
    {
        unsigned long local_ip  = inet_addr(local_ip_addr);
        struct sockaddr_in sockaddr;
        memset(&sockaddr, 0, sizeof(struct sockaddr_in));
        sockaddr.sin_family = AF_INET;
        sockaddr.sin_port = htons(udp_port);
        sockaddr.sin_addr.s_addr = local_ip;
        rc = rt_dev_bind(sock, (struct sockaddr *) &sockaddr, sizeof(struct sockaddr_in));
        if (rc)
        {
            printf("rt_dev_bind: rc=%i\n", rc);
            goto ERROR_OUT;
        }
    }

    rc = rt_task_spawn(&server_task, "server", 0, 10, 0, server_process, NULL);
    if (rc)
    {
        printf("Error: rt_task_init for data_process failed \n");
        goto ERROR_OUT;
    }

    pause();
    return 0;

ERROR_OUT:
    printf("Error out\n");
    return 1;
}
